/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.xstream.converters.reflection.PureJavaReflectionProvider;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.xml.Xpp3Driver;
import com.microsoft.applicationinsights.internal.config.AppInsightsConfigurationBuilder;
import com.microsoft.applicationinsights.internal.config.ApplicationInsightsXmlConfiguration;
import com.microsoft.applicationinsights.internal.config.Java7SaferXStream;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

class JaxbAppInsightsConfigurationBuilder
implements AppInsightsConfigurationBuilder {
    JaxbAppInsightsConfigurationBuilder() {
    }

    @Override
    public ApplicationInsightsXmlConfiguration build(InputStream resourceFile) {
        if (resourceFile == null) {
            return null;
        }
        try {
            Java7SaferXStream xstream = new Java7SaferXStream(new PureJavaReflectionProvider(), new Xpp3Driver());
            xstream.ignoreUnknownElements();
            Java7SaferXStream.setupDefaultSecurity(xstream);
            xstream.allowTypesByWildcard(new String[]{"com.microsoft.applicationinsights.internal.config.*"});
            xstream.processAnnotations(ApplicationInsightsXmlConfiguration.class);
            return (ApplicationInsightsXmlConfiguration)xstream.fromXML(resourceFile);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to parse configuration file: '%s'", ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    private XMLStreamReader getXmlStreamReader(InputStream input) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            return factory.createXMLStreamReader(input);
        }
        catch (Throwable t) {
            InternalLogger.INSTANCE.error("Failed to create stream reader for configuration file: '%s'", ExceptionUtils.getStackTrace(t));
            return null;
        }
    }
}

