/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.services.VradiStorageServiceImpl;
import com.jurismarches.vradi.services.XmlStreamService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.sharengo.exceptions.TechnicalException;

public class XmlStreamServiceImpl
implements XmlStreamService {
    private static final Log log = LogFactory.getLog(VradiStorageServiceImpl.class);
    protected static String channel = "channel";
    protected static String entry = "entry";
    protected static String feed = "feed";
    protected static String item = "item";
    protected static String opt = "opt";
    protected static String rdf = "rdf";

    @Override
    public Element getFirstElement(String url) throws TechnicalException {
        SAXBuilder sxb = new SAXBuilder();
        URL rssUrl = null;
        try {
            rssUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new TechnicalException();
        }
        log.debug((Object)"well formed URL");
        Document document = null;
        try {
            document = sxb.build(rssUrl);
        }
        catch (JDOMException e) {
            log.error((Object)e);
            throw new TechnicalException();
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new TechnicalException();
        }
        Element racine = document.getRootElement();
        log.debug((Object)racine.getName());
        Element itemElt = null;
        if (racine.getChild(item) != null) {
            itemElt = racine.getChild(item);
        } else if (racine.getChild(entry) != null) {
            itemElt = racine.getChild(entry);
        } else if (racine.getChild(channel) != null) {
            itemElt = racine.getChild(channel).getChild(item);
        }
        return itemElt;
    }

    @Override
    public List<String> getRSSFields(Element firstElement) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getRSSFields");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (firstElement != null) {
            for (Element elt : firstElement.getChildren()) {
                result.add(elt.getName());
            }
        }
        return result;
    }

    @Override
    public Map<String, String> getFirstElementValues(Element firstElement) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (firstElement != null) {
            for (Element elt : firstElement.getChildren()) {
                result.put(elt.getName(), elt.getText());
            }
        }
        return result;
    }
}

