/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.javafx;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point3D;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.ValuesConverter;

public class Point3DConverter
extends ValuesConverter<Point3D, Double> {
    public Point3DConverter() {
        super("; ", Double.class);
    }

    public Point3DConverter(String separator) {
        super(separator, Double.class);
    }

    @Override
    public String toString(Point3D point3D, ConverterContext context) {
        if (point3D == null) {
            return null;
        }
        ArrayList<Double> list = new ArrayList<Double>(3);
        list.add(point3D.getX());
        list.add(point3D.getY());
        list.add(point3D.getZ());
        return this.valuesToString(list, context);
    }

    @Override
    public Point3D fromString(String string, ConverterContext context) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        List objects = this.valuesFromString(string, context);
        double x = 0.0;
        if (objects.size() >= 1) {
            Double value = (Double)objects.get(0);
            x = value == null ? 0.0 : value;
        }
        double y = 0.0;
        if (objects.size() >= 2) {
            Double value = (Double)objects.get(1);
            y = value == null ? 0.0 : value;
        }
        double z = 0.0;
        if (objects.size() >= 3) {
            Double value = (Double)objects.get(2);
            z = value == null ? 0.0 : value;
        }
        return new Point3D(x, y, z);
    }
}

