/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.javafx;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point2D;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.ValuesConverter;

public class Point2DConverter
extends ValuesConverter<Point2D, Double> {
    public Point2DConverter() {
        super("; ", Double.class);
    }

    public Point2DConverter(String separator) {
        super(separator, Double.class);
    }

    @Override
    public String toString(Point2D point2D, ConverterContext context) {
        if (point2D == null) {
            return null;
        }
        ArrayList<Double> list = new ArrayList<Double>(2);
        list.add(point2D.getX());
        list.add(point2D.getY());
        return this.valuesToString(list, context);
    }

    @Override
    public Point2D fromString(String string, ConverterContext context) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        List objects = this.valuesFromString(string, context);
        double x = 0.0;
        if (objects.size() >= 1) {
            Double value = (Double)objects.get(0);
            x = value == null ? 0.0 : value;
        }
        double y = 0.0;
        if (objects.size() >= 2) {
            Double value = (Double)objects.get(1);
            y = value == null ? 0.0 : value;
        }
        return new Point2D(x, y);
    }
}

