/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.javafx;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Dimension2D;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.ValuesConverter;

public class Dimension2DConverter
extends ValuesConverter<Dimension2D, Double> {
    public Dimension2DConverter() {
        super("; ", Double.class);
    }

    public Dimension2DConverter(String separator) {
        super(separator, Double.class);
    }

    @Override
    public String toString(Dimension2D dimension2D, ConverterContext context) {
        if (dimension2D == null) {
            return null;
        }
        ArrayList<Double> list = new ArrayList<Double>(2);
        list.add(dimension2D.getWidth());
        list.add(dimension2D.getHeight());
        return this.valuesToString(list, context);
    }

    @Override
    public Dimension2D fromString(String string, ConverterContext context) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        List objects = this.valuesFromString(string, context);
        double width = 0.0;
        if (objects.size() >= 1) {
            Double value = (Double)objects.get(0);
            width = value == null ? 0.0 : value;
        }
        double height = 0.0;
        if (objects.size() >= 2) {
            Double value = (Double)objects.get(1);
            height = value == null ? 0.0 : value;
        }
        return new Dimension2D(width, height);
    }
}

