/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.DefaultObjectConverter;

public class YearMonthConverter
extends DefaultObjectConverter<Calendar> {
    public static final String PROPERTY_DATE_FORMAT = "DateFormat";
    public static final ConverterContext CONTEXT_YEAR_MONTH = new ConverterContext("YearMonth");
    private DateFormat _conciseFormat = new SimpleDateFormat("MMyy");
    private DateFormat _shortFormat = new SimpleDateFormat("MM/yy");
    private DateFormat _mediumFormat = new SimpleDateFormat("MM, yyyy");
    private DateFormat _longFormat = new SimpleDateFormat("MMMMM, yyyy");
    private DateFormat _defaultDateFormat = this._shortFormat;

    @Override
    public String toString(Calendar value, ConverterContext context) {
        Object format;
        if (value == null) {
            return "";
        }
        Object object = format = context != null ? context.getProperties().get((Object)PROPERTY_DATE_FORMAT) : null;
        if (format instanceof DateFormat) {
            return ((DateFormat)format).format(value);
        }
        return this.getDefaultDateFormat().format(value.getTime());
    }

    @Override
    public Calendar fromString(String string, ConverterContext context) {
        Calendar calendar = Calendar.getInstance();
        try {
            Object format;
            Object object = format = context != null ? context.getProperties().get((Object)PROPERTY_DATE_FORMAT) : null;
            if (format instanceof DateFormat) {
                Date time = ((DateFormat)format).parse(string);
                calendar.setTime(time);
            } else {
                Date time = this.getDefaultDateFormat().parse(string);
                calendar.setTime(time);
            }
        }
        catch (ParseException e1) {
            try {
                Date time = this._shortFormat.parse(string);
                calendar.setTime(time);
            }
            catch (ParseException e2) {
                try {
                    Date time = this._mediumFormat.parse(string);
                    calendar.setTime(time);
                }
                catch (ParseException e3) {
                    try {
                        Date time = this._longFormat.parse(string);
                        calendar.setTime(time);
                    }
                    catch (ParseException e4) {
                        try {
                            Date time = this._conciseFormat.parse(string);
                            calendar.setTime(time);
                        }
                        catch (ParseException e5) {
                            return null;
                        }
                    }
                }
            }
        }
        return calendar;
    }

    public DateFormat getDefaultDateFormat() {
        return this._defaultDateFormat;
    }

    public void setDefaultDateFormat(DateFormat defaultDateFormat) {
        this._defaultDateFormat = defaultDateFormat;
    }
}

