/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import java.io.File;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.util.Calendar;
import java.util.Date;
import javafx.geometry.BoundingBox;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import jidefx.utils.converter.AbstractNumberConverter;
import jidefx.utils.converter.BigDecimalConverter;
import jidefx.utils.converter.BooleanConverter;
import jidefx.utils.converter.ByteConverter;
import jidefx.utils.converter.CacheMap;
import jidefx.utils.converter.CalendarConverter;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.CurrencyConverter;
import jidefx.utils.converter.DateConverter;
import jidefx.utils.converter.DefaultObjectConverter;
import jidefx.utils.converter.DefaultValuesConverter;
import jidefx.utils.converter.DoubleConverter;
import jidefx.utils.converter.EnumConverter;
import jidefx.utils.converter.FileConverter;
import jidefx.utils.converter.FloatConverter;
import jidefx.utils.converter.IntegerConverter;
import jidefx.utils.converter.LazyInitializeConverter;
import jidefx.utils.converter.LongConverter;
import jidefx.utils.converter.MonthNameConverter;
import jidefx.utils.converter.MultilineStringConverter;
import jidefx.utils.converter.NaturalNumberConverter;
import jidefx.utils.converter.ObjectConverter;
import jidefx.utils.converter.PercentConverter;
import jidefx.utils.converter.QuarterNameConverter;
import jidefx.utils.converter.RequiringConverterManager;
import jidefx.utils.converter.ShortConverter;
import jidefx.utils.converter.StringArrayConverter;
import jidefx.utils.converter.TypeUtils;
import jidefx.utils.converter.YearMonthConverter;
import jidefx.utils.converter.javafx.BoundingBoxConverter;
import jidefx.utils.converter.javafx.ColorConverter;
import jidefx.utils.converter.javafx.Dimension2DConverter;
import jidefx.utils.converter.javafx.FontConverter;
import jidefx.utils.converter.javafx.HexColorConverter;
import jidefx.utils.converter.javafx.InsetsConverter;
import jidefx.utils.converter.javafx.Point2DConverter;
import jidefx.utils.converter.javafx.Point3DConverter;
import jidefx.utils.converter.javafx.Rectangle2DConverter;
import jidefx.utils.converter.javafx.RgbColorConverter;
import jidefx.utils.converter.javafx.WebColorConverter;
import jidefx.utils.converter.time.LocalDateConverter;
import jidefx.utils.converter.time.LocalDateTimeConverter;
import jidefx.utils.converter.time.LocalTimeConverter;

public class ObjectConverterManager {
    public static final String PROPERTY_OBJECT_CONVERTER_MANAGER = "ObjectConverterManager";
    private static final ObjectConverterManager _instance = ObjectConverterManager.createInstance();
    private boolean _inited = false;
    private boolean _initing = false;
    private boolean _autoInit = true;
    private CacheMap<ObjectConverter, ConverterContext> _cache = new CacheMap(ConverterContext.CONTEXT_DEFAULT);
    private ObjectConverter _defaultConverter = new DefaultObjectConverter();

    public static ObjectConverterManager createInstance() {
        return new ObjectConverterManager();
    }

    public static ObjectConverterManager getInstance() {
        return _instance;
    }

    public static ObjectConverterManager getInstance(Node node) {
        if (node != null && node.getProperties().get((Object)PROPERTY_OBJECT_CONVERTER_MANAGER) instanceof ObjectConverterManager) {
            return (ObjectConverterManager)node.getProperties().get((Object)PROPERTY_OBJECT_CONVERTER_MANAGER);
        }
        return ObjectConverterManager.getInstance();
    }

    public void resetInit() {
        this._inited = false;
    }

    public void clear() {
        this.resetInit();
        this._cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDefaultConverters() {
        if (this._inited) {
            return;
        }
        this._initing = true;
        try {
            this.registerConverter(String.class, new DefaultObjectConverter());
            this.registerConverter(String.class, new MultilineStringConverter(), MultilineStringConverter.CONTEXT);
            IntegerConverter integerConverter = new IntegerConverter();
            this.registerConverter(Integer.TYPE, integerConverter);
            this.registerConverter(Integer.class, integerConverter);
            NaturalNumberConverter naturalNumberConverter = new NaturalNumberConverter();
            this.registerConverter(Integer.TYPE, naturalNumberConverter, NaturalNumberConverter.CONTEXT);
            this.registerConverter(Integer.class, naturalNumberConverter, NaturalNumberConverter.CONTEXT);
            ShortConverter shortConverter = new ShortConverter();
            this.registerConverter(Short.class, shortConverter);
            this.registerConverter(Short.TYPE, shortConverter);
            LongConverter longConverter = new LongConverter();
            this.registerConverter(Long.class, longConverter);
            this.registerConverter(Long.TYPE, longConverter);
            DoubleConverter doubleConverter = new DoubleConverter();
            this.registerConverter(Double.class, doubleConverter);
            this.registerConverter(Double.TYPE, doubleConverter);
            NumberFormat format1DigitInstance = NumberFormat.getNumberInstance();
            format1DigitInstance.setMinimumFractionDigits(1);
            format1DigitInstance.setMaximumFractionDigits(1);
            DoubleConverter fraction1DigitConverter = new DoubleConverter(format1DigitInstance);
            this.registerConverter(Number.class, fraction1DigitConverter, AbstractNumberConverter.CONTEXT_FIXED_1_DIGIT_FRACTION);
            NumberFormat format2Digit = NumberFormat.getNumberInstance();
            format2Digit.setMinimumFractionDigits(2);
            format2Digit.setMaximumFractionDigits(2);
            DoubleConverter fraction2DigitConverter = new DoubleConverter(format2Digit);
            this.registerConverter(Number.class, fraction2DigitConverter, AbstractNumberConverter.CONTEXT_FIXED_2_DIGIT_FRACTION);
            NumberFormat format4Digit = NumberFormat.getNumberInstance();
            format4Digit.setMinimumFractionDigits(4);
            format4Digit.setMaximumFractionDigits(4);
            DoubleConverter fraction4DigitConverter = new DoubleConverter(format4Digit);
            this.registerConverter(Number.class, fraction4DigitConverter, AbstractNumberConverter.CONTEXT_FIXED_4_DIGIT_FRACTION);
            FloatConverter floatConverter = new FloatConverter();
            this.registerConverter(Float.class, floatConverter);
            this.registerConverter(Float.TYPE, floatConverter);
            this.registerConverter(BigDecimal.class, new BigDecimalConverter());
            ByteConverter byteConverter = new ByteConverter();
            this.registerConverter(Byte.class, byteConverter);
            this.registerConverter(Byte.TYPE, byteConverter);
            BooleanConverter booleanConverter = new BooleanConverter();
            this.registerConverter(Boolean.class, booleanConverter);
            this.registerConverter(Boolean.TYPE, booleanConverter);
            this.registerConverter(File.class, new FileConverter());
            QuarterNameConverter quarterNameConverter = new QuarterNameConverter();
            this.registerConverter(Integer.TYPE, quarterNameConverter, QuarterNameConverter.CONTEXT);
            this.registerConverter(Integer.class, quarterNameConverter, QuarterNameConverter.CONTEXT);
            CurrencyConverter currencyConverter = new CurrencyConverter();
            this.registerConverter(Float.class, currencyConverter, CurrencyConverter.CONTEXT);
            this.registerConverter(Float.TYPE, currencyConverter, CurrencyConverter.CONTEXT);
            this.registerConverter(Double.class, currencyConverter, CurrencyConverter.CONTEXT);
            this.registerConverter(Double.TYPE, currencyConverter, CurrencyConverter.CONTEXT);
            PercentConverter percentConverter = new PercentConverter();
            this.registerConverter(Float.class, percentConverter, PercentConverter.CONTEXT);
            this.registerConverter(Float.TYPE, percentConverter, PercentConverter.CONTEXT);
            this.registerConverter(Double.class, percentConverter, PercentConverter.CONTEXT);
            this.registerConverter(Double.TYPE, percentConverter, PercentConverter.CONTEXT);
            DateConverter dateConverter = new DateConverter();
            this.registerConverter(Date.class, dateConverter);
            this.registerConverter(Date.class, dateConverter, DateConverter.CONTEXT_DATETIME);
            this.registerConverter(Date.class, dateConverter, DateConverter.CONTEXT_TIME);
            CalendarConverter calendarConverter = new CalendarConverter();
            this.registerConverter(Calendar.class, calendarConverter);
            this.registerConverter(Calendar.class, calendarConverter, DateConverter.CONTEXT_DATETIME);
            this.registerConverter(Calendar.class, calendarConverter, DateConverter.CONTEXT_TIME);
            this.registerConverter(Calendar.class, new YearMonthConverter(), YearMonthConverter.CONTEXT_YEAR_MONTH);
            this.registerConverter(LocalDate.class, new LocalDateConverter());
            this.registerConverter(LocalDateTime.class, new LocalDateTimeConverter());
            this.registerConverter(LocalTime.class, new LocalTimeConverter());
            this.registerConverter(YearMonth.class, new YearMonthConverter());
            MonthNameConverter monthNameConverter = new MonthNameConverter();
            this.registerConverter(Integer.class, monthNameConverter, MonthNameConverter.CONTEXT);
            this.registerConverter(Integer.TYPE, monthNameConverter, MonthNameConverter.CONTEXT);
            this.registerConverter(Color.class, new RgbColorConverter());
            this.registerConverter(Color.class, new HexColorConverter(), ColorConverter.CONTEXT_HEX);
            this.registerConverter(Color.class, new RgbColorConverter(true), ColorConverter.CONTEXT_RGBA);
            this.registerConverter(Color.class, new HexColorConverter(true), ColorConverter.CONTEXT_HEX_WITH_ALPHA);
            this.registerConverter(Color.class, new WebColorConverter(), ColorConverter.CONTEXT_WEB);
            this.registerConverter(Point2D.class, new Point2DConverter());
            this.registerConverter(Point3D.class, new Point3DConverter());
            this.registerConverter(Rectangle2D.class, new Rectangle2DConverter());
            this.registerConverter(Dimension2D.class, new Dimension2DConverter());
            this.registerConverter(Insets.class, new InsetsConverter());
            this.registerConverter(BoundingBox.class, new BoundingBoxConverter());
            this.registerConverter(Font.class, new FontConverter());
            this.registerConverter(Enum.class, new EnumConverter());
            this.registerConverter(String[].class, new StringArrayConverter());
            this.registerConverter(int[].class, new DefaultValuesConverter("; ", Integer.TYPE));
            this.registerConverter(float[].class, new DefaultValuesConverter("; ", Float.TYPE));
            this.registerConverter(double[].class, new DefaultValuesConverter("; ", Double.TYPE));
            this.registerConverter(long[].class, new DefaultValuesConverter("; ", Long.TYPE));
            this.registerConverter(short[].class, new DefaultValuesConverter("; ", Short.TYPE));
            this.registerConverter(Object[].class, new DefaultValuesConverter("; ", Object.class));
            this.registerConverter(String[].class, new DefaultValuesConverter("; ", String.class));
            this.registerConverter(Date[].class, new DefaultValuesConverter("; ", Date.class));
            this.registerConverter(Calendar[].class, new DefaultValuesConverter("; ", Calendar.class));
            this.registerConverter(Number[].class, new DefaultValuesConverter("; ", Number.class));
            this.registerConverter(Integer[].class, new DefaultValuesConverter("; ", Integer.class));
            this.registerConverter(Float[].class, new DefaultValuesConverter("; ", Float.class));
            this.registerConverter(Double[].class, new DefaultValuesConverter("; ", Double.class));
            this.registerConverter(Long[].class, new DefaultValuesConverter("; ", Long.class));
            this.registerConverter(Short[].class, new DefaultValuesConverter("; ", Short.class));
        }
        finally {
            this._initing = false;
            this._inited = true;
        }
    }

    public void registerConverter(Class<?> clazz, ObjectConverter converter, ConverterContext context) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter class cannot be null");
        }
        if (context == null) {
            context = ConverterContext.CONTEXT_DEFAULT;
        }
        if (this.isAutoInit() && !this._inited && !this._initing) {
            this.initDefaultConverters();
        }
        this._cache.register(clazz, converter, context);
    }

    public void registerConverter(Class<?> clazz, ObjectConverter converter) {
        this.registerConverter(clazz, converter, ConverterContext.CONTEXT_DEFAULT);
    }

    public void unregisterConverter(Class<?> clazz, ConverterContext context) {
        if (context == null) {
            context = ConverterContext.CONTEXT_DEFAULT;
        }
        if (this.isAutoInit() && !this._inited && !this._initing) {
            this.initDefaultConverters();
        }
        this._cache.unregister(clazz, context);
    }

    public void unregisterConverter(Class<?> clazz) {
        this.unregisterConverter(clazz, ConverterContext.CONTEXT_DEFAULT);
    }

    public void unregisterAllConverters(Class<?> clazz) {
        this._cache.remove(clazz);
    }

    public void unregisterAllConverters() {
        this._cache.clear();
    }

    public <T> ObjectConverter<T> getConverter(Class<?> clazz) {
        return this.getConverter(clazz, ConverterContext.CONTEXT_DEFAULT);
    }

    public <T> ObjectConverter<T> getConverter(Class<?> clazz, ConverterContext context) {
        ObjectConverter converter;
        if (this.isAutoInit() && !this._inited && !this._initing) {
            this.initDefaultConverters();
        }
        if (context == null) {
            context = ConverterContext.CONTEXT_DEFAULT;
        }
        if ((converter = this._cache.getRegisteredObject(clazz, context)) != null) {
            if (converter instanceof LazyInitializeConverter) {
                ((LazyInitializeConverter)((Object)converter)).initialize(clazz, context);
            }
            return converter;
        }
        if (clazz != null && clazz.isArray()) {
            DefaultValuesConverter defaultArrayConverter = new DefaultValuesConverter("; ", clazz.getComponentType());
            this.registerConverter(clazz, defaultArrayConverter);
            return defaultArrayConverter;
        }
        return this._defaultConverter;
    }

    public String toString(Object object) {
        if (object != null) {
            return this.toString(object, object.getClass(), ConverterContext.CONTEXT_DEFAULT);
        }
        return "";
    }

    public String toString(Object object, Class<?> clazz) {
        return this.toString(object, clazz, ConverterContext.CONTEXT_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Object object, Class<?> clazz, ConverterContext context) {
        ObjectConverter<Object> converter = this.getConverter(clazz, context);
        if (converter != null) {
            String s;
            if (converter instanceof RequiringConverterManager) {
                context.getProperties().put((Object)PROPERTY_OBJECT_CONVERTER_MANAGER, (Object)this);
            }
            try {
                s = converter.toString(object, context);
            }
            finally {
                if (converter instanceof RequiringConverterManager) {
                    context.getProperties().remove((Object)PROPERTY_OBJECT_CONVERTER_MANAGER);
                }
            }
            return s;
        }
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public Object fromString(String string, Class<?> clazz) {
        return this.fromString(string, clazz, ConverterContext.CONTEXT_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fromString(String string, Class<?> clazz, ConverterContext context) {
        ObjectConverter converter = this.getConverter(clazz, context);
        if (converter != null) {
            Object value;
            try {
                if (converter instanceof RequiringConverterManager) {
                    context.getProperties().put((Object)PROPERTY_OBJECT_CONVERTER_MANAGER, (Object)this);
                }
                value = converter.fromString(string, context);
            }
            finally {
                if (converter instanceof RequiringConverterManager) {
                    context.getProperties().remove((Object)PROPERTY_OBJECT_CONVERTER_MANAGER);
                }
            }
            if (value != null && clazz != null && !clazz.isAssignableFrom(value.getClass()) && TypeUtils.isNumericType(clazz) && value instanceof Number) {
                if ((clazz = TypeUtils.convertPrimitiveToWrapperType(clazz)) == Double.class) {
                    return ((Number)value).doubleValue();
                }
                if (clazz == Byte.class) {
                    return ((Number)value).byteValue();
                }
                if (clazz == Short.class) {
                    return ((Number)value).shortValue();
                }
                if (clazz == Integer.class) {
                    return ((Number)value).intValue();
                }
                if (clazz == Long.class) {
                    return ((Number)value).longValue();
                }
                if (clazz == Float.class) {
                    return Float.valueOf(((Number)value).floatValue());
                }
            }
            return value;
        }
        return null;
    }

    public boolean isAutoInit() {
        return this._autoInit;
    }

    public void setAutoInit(boolean autoInit) {
        this._autoInit = autoInit;
    }

    public ConverterContext[] getConverterContexts(Class<?> clazz) {
        return this._cache.getKeys(clazz, (ConverterContext[])new ConverterContext[0]);
    }
}

