/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import jidefx.utils.converter.TypeUtils;

class CacheMap<T, K> {
    private HashMap<Class<?>, Cache<K, T>> _cache = new HashMap();
    private K _defaultContext;

    CacheMap(K defaultContext) {
        this._defaultContext = defaultContext;
    }

    protected Cache<K, T> getCache(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz cannot be null");
        }
        return this._cache.get(clazz);
    }

    public K[] getKeys(Class<?> clazz, K[] a) {
        Cache<K, T> cache = this.getCache(clazz);
        if (cache != null) {
            Set set = cache.keySet();
            return set.toArray(a);
        }
        return a;
    }

    protected Cache<K, T> initCache(Class<?> clazz) {
        Cache<K, T> cache = this.getCache(clazz);
        if (cache != null) {
            return cache;
        }
        cache = new Cache();
        this._cache.put(clazz, cache);
        return cache;
    }

    public void register(Class<?> clazz, T object, K context) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz cannot be null");
        }
        if (TypeUtils.isPrimitiveWrapper(clazz)) {
            Class<?> primitiveType = TypeUtils.convertWrapperToPrimitiveType(clazz);
            this.register(primitiveType, object, context);
        }
        Cache<K, T> cache = this.initCache(clazz);
        cache.setObject(context, object);
    }

    public void unregister(Class<?> clazz, K context) {
        Cache<K, T> cache = this.getCache(clazz);
        if (cache != null) {
            cache.setObject(context, null);
            if (cache.size() == 0) {
                this._cache.remove(clazz);
            }
        }
    }

    public T getRegisteredObject(Class<?> clazz, K context) {
        if (clazz == null) {
            return null;
        }
        Cache<K, T> cache = this.getCache(clazz);
        if (cache == null || !cache.containsKey(context)) {
            T object;
            Cache<K, T> cacheForClass;
            ArrayList classesToSearch = new ArrayList();
            classesToSearch.add(clazz);
            if (TypeUtils.isPrimitive(clazz)) {
                classesToSearch.add(TypeUtils.convertPrimitiveToWrapperType(clazz));
            } else if (TypeUtils.isPrimitiveWrapper(clazz)) {
                classesToSearch.add(TypeUtils.convertWrapperToPrimitiveType(clazz));
            }
            this.addAllInterfaces(classesToSearch, clazz);
            Class<?> superClass = clazz;
            while (!superClass.isInterface() && (superClass = superClass.getSuperclass()) != null) {
                classesToSearch.add(superClass);
                this.addAllInterfaces(classesToSearch, superClass);
            }
            if (!classesToSearch.contains(Object.class)) {
                classesToSearch.add(Object.class);
            }
            for (Class clazz2 : classesToSearch) {
                cacheForClass = this.getCache(clazz2);
                if (cacheForClass == null || (object = cacheForClass.getObject(context)) == null) continue;
                return object;
            }
            if (!this._defaultContext.equals(context)) {
                for (Class clazz3 : classesToSearch) {
                    cacheForClass = this.getCache(clazz3);
                    if (cacheForClass == null || (object = cacheForClass.getObject(this._defaultContext)) == null) continue;
                    return object;
                }
            }
        }
        if (cache != null) {
            T object = cache.getObject(context);
            if (object == null && !this._defaultContext.equals(context)) {
                return this.getRegisteredObject(clazz, this._defaultContext);
            }
            if (object != null) {
                return object;
            }
        }
        return null;
    }

    private void addAllInterfaces(List<Class<?>> list, Class<?> clazz) {
        Class<?>[] interfaces;
        for (Class<?> it : interfaces = clazz.getInterfaces()) {
            list.add(it);
            this.addAllInterfaces(list, it);
        }
    }

    public T getMatchRegisteredObject(Class<?> clazz, K context) {
        T object;
        Cache<K, T> cache;
        if (clazz == null) {
            return null;
        }
        if (context == null) {
            context = this._defaultContext;
        }
        if ((cache = this.getCache(clazz)) != null && (object = cache.getObject(context)) != null) {
            return object;
        }
        return null;
    }

    public List<T> getValues() {
        ArrayList list = new ArrayList();
        Collection<Cache<K, T>> col = this._cache.values();
        for (Cache<K, T> o : col) {
            Collection col2 = o.values();
            for (Object o2 : col2) {
                if (list.contains(o2)) continue;
                list.add(o2);
            }
        }
        return list;
    }

    public void remove(Class<?> clazz) {
        Cache<Object, T> cache = this.getCache(clazz);
        if (cache != null) {
            Object[] keys;
            for (Object context : keys = cache.keySet().toArray()) {
                cache.setObject(context, null);
            }
        }
        this._cache.remove(clazz);
    }

    public void clear() {
        this._cache.clear();
    }

    static class Cache<K, T>
    extends HashMap<K, T> {
        private static final long serialVersionUID = 7764545350468551102L;

        Cache() {
        }

        public T getObject(K context) {
            return (T)this.get(context);
        }

        public void setObject(K context, T object) {
            if (object == null) {
                this.remove(context);
            } else {
                this.put(context, object);
            }
        }
    }
}

