/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.chart.components;

import com.jgeppert.struts2.jquery.chart.components.Chart;
import com.jgeppert.struts2.jquery.components.AbstractContainer;
import com.jgeppert.struts2.jquery.components.DatePicker;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.struts2.util.MakeIterator;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="chartData", tldTagClass="com.jgeppert.struts2.jquery.chart.views.jsp.ui.ChartDataTag", description="Data for the Chart Element", allowDynamicAttributes=true)
public class ChartData
extends AbstractContainer {
    public static final String TEMPLATE = "chart-data";
    public static final String TEMPLATE_CLOSE = "chart-data-close";
    public static final String COMPONENT_NAME = ChartData.class.getName();
    protected static final Logger LOG = LoggerFactory.getLogger(DatePicker.class);
    private static final transient Random RANDOM = new Random();
    protected String color;
    protected String label;
    protected String lines;
    protected String bars;
    protected String points;
    protected String xaxis;
    protected String yaxis;
    protected String clickable;
    protected String hoverable;
    protected String shadowSize;
    protected String fillBetween;
    protected String data;
    protected Object list;
    protected String listKey;
    protected String listValue;

    public ChartData(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public void evaluateExtraParams() {
        Chart chart;
        super.evaluateExtraParams();
        if (this.color != null) {
            this.addParameter("color", this.findString(this.color));
        }
        if (this.label != null) {
            this.addParameter("label", this.findString(this.label));
        }
        if (this.lines != null) {
            this.addParameter("lines", this.findString(this.lines));
        }
        if (this.bars != null) {
            this.addParameter("bars", this.findString(this.bars));
        }
        if (this.points != null) {
            this.addParameter("points", this.findString(this.points));
        }
        if (this.xaxis != null) {
            this.addParameter("xaxis", this.findValue(this.xaxis, Integer.class));
        }
        if (this.yaxis != null) {
            this.addParameter("yaxis", this.findValue(this.yaxis, Integer.class));
        }
        if (this.clickable != null) {
            this.addParameter("clickable", this.findValue(this.clickable, Boolean.class));
        }
        if (this.hoverable != null) {
            this.addParameter("hoverable", this.findValue(this.hoverable, Boolean.class));
        }
        if (this.shadowSize != null) {
            this.addParameter("shadowSize", this.findValue(this.shadowSize, Integer.class));
        }
        if (this.fillBetween != null) {
            this.addParameter("fillBetween", this.findString(this.fillBetween));
        }
        if (this.id == null || this.id.length() == 0) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = "chartdata" + String.valueOf(nextInt);
            this.addParameter("id", this.id);
        }
        if ((chart = (Chart)this.findAncestor(Chart.class)) != null) {
            this.addParameter("chart", chart.getId());
        }
        if (this.href != null && !this.href.equals("#")) {
            if (this.list != null) {
                this.addParameter("remoteList", this.findString(this.list.toString()));
            }
            if (this.listKey != null) {
                this.addParameter("remoteListKey", this.findString(this.listKey));
            }
            if (this.listValue != null) {
                this.addParameter("remoteListValue", this.findString(this.listValue));
            }
        } else if (this.data != null) {
            this.addParameter("data", this.findString(this.data));
        } else {
            Object listObject;
            if (this.list == null) {
                this.list = this.parameters.get("list");
            }
            if ((listObject = this.findValue(this.list.toString())) instanceof String) {
                this.addParameter("data", listObject);
            } else if (listObject instanceof Map) {
                Map map = (Map)listObject;
                Set keySet = map.keySet();
                StringBuffer data = new StringBuffer();
                data.append("[");
                boolean setComma = false;
                for (Object key : keySet) {
                    if (setComma) {
                        data.append(",");
                    }
                    if (!setComma) {
                        setComma = true;
                    }
                    data.append("[");
                    if (key instanceof Date) {
                        data.append(((Date)key).getTime());
                    } else {
                        data.append(key.toString());
                    }
                    data.append(",");
                    data.append(map.get(key));
                    data.append("]");
                }
                data.append("]");
                this.addParameter("data", data.toString());
            } else {
                Iterator iterator = null;
                iterator = listObject instanceof Collection ? ((Collection)listObject).iterator() : MakeIterator.convert((Object)listObject);
                if (iterator != null) {
                    StringBuffer data = new StringBuffer();
                    data.append("[");
                    Object item = iterator.next();
                    boolean iterat = true;
                    int count = 0;
                    while (iterat) {
                        ++count;
                        if (item == null) {
                            data.append("null");
                        } else if (item instanceof Point) {
                            data.append("[");
                            Point point = (Point)item;
                            data.append(point.getX());
                            data.append(",");
                            data.append(point.getY());
                            data.append("]");
                        } else {
                            data.append("[");
                            if (this.listKey != null) {
                                String key = this.findString(this.listKey);
                                String itemKey = null;
                                try {
                                    itemKey = (String)PropertyUtils.getSimpleProperty(item, (String)key);
                                }
                                catch (IllegalAccessException e) {
                                    LOG.warn("Cannot read listKey", (Throwable)e, new String[0]);
                                }
                                catch (InvocationTargetException e) {
                                    LOG.warn("Cannot read listKey", (Throwable)e, new String[0]);
                                }
                                catch (NoSuchMethodException e) {
                                    LOG.warn("Cannot read listKey", (Throwable)e, new String[0]);
                                }
                                if (itemKey != null) {
                                    data.append(itemKey);
                                } else {
                                    data.append(count);
                                }
                            } else {
                                data.append(count);
                            }
                            data.append(",");
                            if (this.listValue != null) {
                                String value = this.findString(this.listValue);
                                String itemValue = null;
                                try {
                                    itemValue = (String)PropertyUtils.getSimpleProperty(item, (String)value);
                                }
                                catch (IllegalAccessException e) {
                                    LOG.warn("Cannot read listValue", (Throwable)e, new String[0]);
                                }
                                catch (InvocationTargetException e) {
                                    LOG.warn("Cannot read listValue", (Throwable)e, new String[0]);
                                }
                                catch (NoSuchMethodException e) {
                                    LOG.warn("Cannot read listValue", (Throwable)e, new String[0]);
                                }
                                if (itemValue != null) {
                                    data.append(itemValue);
                                } else {
                                    data.append(item.toString());
                                }
                            } else {
                                data.append(item.toString());
                            }
                            data.append("]");
                        }
                        if (iterator.hasNext()) {
                            data.append(",");
                            item = iterator.next();
                            continue;
                        }
                        iterat = false;
                    }
                    data.append("]");
                    this.addParameter("data", data.toString());
                }
            }
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    @StrutsTagAttribute(description="color or number")
    public void setColor(String color) {
        this.color = color;
    }

    @StrutsTagAttribute(description="The Data Label")
    public void setLabel(String label) {
        this.label = label;
    }

    @StrutsTagAttribute(description="specific lines options")
    public void setLines(String lines) {
        this.lines = lines;
    }

    @StrutsTagAttribute(description="specific bars options")
    public void setBars(String bars) {
        this.bars = bars;
    }

    @StrutsTagAttribute(description="specific points options")
    public void setPoints(String points) {
        this.points = points;
    }

    @StrutsTagAttribute(description="1 or 2", type="Integer")
    public void setXaxis(String xaxis) {
        this.xaxis = xaxis;
    }

    @StrutsTagAttribute(description="1 or 2", type="Integer")
    public void setYaxis(String yaxis) {
        this.yaxis = yaxis;
    }

    @StrutsTagAttribute(description="can be set to false to disable interactivity for specific series if interactivity is turned on in the plot Default: true", defaultValue="false", type="Boolean")
    public void setClickable(String clickable) {
        this.clickable = clickable;
    }

    @StrutsTagAttribute(description="can be set to false to disable interactivity for specific series if interactivity is turned on in the plot Default: true", defaultValue="true", type="Boolean")
    public void setHoverable(String hoverable) {
        this.hoverable = hoverable;
    }

    @StrutsTagAttribute(description="Shadow Size", type="Integer")
    public void setShadowSize(String shadowSize) {
        this.shadowSize = shadowSize;
    }

    @StrutsTagAttribute(description="fill the area between two series.")
    public void setFillBetween(String fillBetween) {
        this.fillBetween = fillBetween;
    }

    @StrutsTagAttribute(description="Chart Data. Don't use list and data attributes together. When using a Pie Chart data can be a numerical value like 10.")
    public void setData(String data) {
        this.data = data;
    }

    @StrutsTagAttribute(description="Iterable source to populate from. If the list is a Map (key, value), the Map key will become the option 'value' parameter and the Map value will become the option body.", required=false)
    public void setList(Object list) {
        this.list = list;
    }

    @StrutsTagAttribute(description=" Property of list objects to get field value from")
    public void setListKey(String listKey) {
        this.listKey = listKey;
    }

    @StrutsTagAttribute(description="Property of list objects to get field content from")
    public void setListValue(String listValue) {
        this.listValue = listValue;
    }
}

