/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.AnnotatedLevels;
import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.CollectionsWriters;
import com.jerolba.carpet.impl.write.FieldWriterConsumer;
import com.jerolba.carpet.impl.write.ModelFieldsWriter;
import com.jerolba.carpet.impl.write.RecordField;
import com.jerolba.carpet.impl.write.WriteModelField;
import com.jerolba.carpet.model.CollectionType;
import com.jerolba.carpet.model.FieldType;
import com.jerolba.carpet.model.MapType;
import com.jerolba.carpet.model.WriteField;
import com.jerolba.carpet.model.WriteRecordModelType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.parquet.io.api.RecordConsumer;

class WriteRecordModelWriter {
    private final RecordConsumer recordConsumer;
    private final CarpetWriteConfiguration carpetConfiguration;
    private final List<Consumer<Object>> fieldWriters = new ArrayList<Consumer<Object>>();

    public WriteRecordModelWriter(RecordConsumer recordConsumer, WriteRecordModelType<?> writeRecordModelType, CarpetWriteConfiguration carpetConfiguration) {
        this.recordConsumer = recordConsumer;
        this.carpetConfiguration = carpetConfiguration;
        int idx = 0;
        for (WriteField<?> field : writeRecordModelType.getFields()) {
            Consumer<Object> writer = this.buildFieldWriter(recordConsumer, idx, field);
            if (writer == null) {
                throw new RuntimeException(field.fieldType().getClass().getName() + " can not be serialized");
            }
            this.fieldWriters.add(writer);
            ++idx;
        }
    }

    public void write(Object record) {
        for (Consumer<Object> fieldWriter : this.fieldWriters) {
            fieldWriter.accept(record);
        }
    }

    private Consumer<Object> buildFieldWriter(RecordConsumer recordConsumer, int idx, WriteField<?> field) {
        if (field instanceof WriteRecordModelType.PrimitiveJavaFieldInfo) {
            WriteRecordModelType.PrimitiveJavaFieldInfo primitiveJavaField = (WriteRecordModelType.PrimitiveJavaFieldInfo)field;
            return ModelFieldsWriter.buildPrimitiveJavaConsumer(primitiveJavaField, idx, recordConsumer);
        }
        if (field instanceof WriteRecordModelType.FunctionFieldInfo) {
            WriteRecordModelType.FunctionFieldInfo functionField = (WriteRecordModelType.FunctionFieldInfo)field;
            Function<Object, Object> accessor = functionField.accessor();
            WriteModelField modelField = new WriteModelField(field.parquetFieldName(), idx, accessor);
            FieldType type = field.fieldType();
            if (type instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)type;
                return this.createCollectionWriter(collectionType, modelField);
            }
            if (type instanceof MapType) {
                MapType mapType = (MapType)type;
                return this.createMapStructureWriter(mapType, modelField);
            }
            BiConsumer<RecordConsumer, Object> basicTypeWriter = ModelFieldsWriter.buildSimpleElementConsumer(type, recordConsumer, this.carpetConfiguration);
            if (basicTypeWriter != null) {
                return new FieldWriterConsumer(recordConsumer, modelField, basicTypeWriter);
            }
        }
        return null;
    }

    private Consumer<Object> createCollectionWriter(CollectionType collectionType, RecordField recordField) {
        return switch (this.carpetConfiguration.annotatedLevels()) {
            default -> throw new IncompatibleClassChangeError();
            case AnnotatedLevels.ONE -> this.createOneLevelStructureWriter(collectionType.type(), recordField);
            case AnnotatedLevels.TWO -> this.createTwoLevelStructureWriter(collectionType.type(), recordField);
            case AnnotatedLevels.THREE -> this.createThreeLevelStructureWriter(collectionType.type(), recordField);
        };
    }

    private Consumer<Object> createOneLevelStructureWriter(FieldType parametized, RecordField recordField) {
        if (parametized instanceof CollectionType) {
            throw new RecordTypeConversionException("Nested collection in a collection is not supported in single level structure codification");
        }
        BiConsumer<RecordConsumer, Object> elemConsumer = null;
        if (parametized instanceof MapType) {
            MapType mapType = (MapType)parametized;
            Consumer<Object> childWriter = this.createMapStructureWriter(mapType, null);
            elemConsumer = (consumer, v) -> childWriter.accept(v);
        } else {
            elemConsumer = ModelFieldsWriter.buildSimpleElementConsumer(parametized, this.recordConsumer, this.carpetConfiguration);
        }
        if (elemConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in collection");
        }
        return new CollectionsWriters.OneLevelCollectionFieldWriter(this.recordConsumer, recordField, elemConsumer);
    }

    private Consumer<Object> createTwoLevelStructureWriter(FieldType parametized, RecordField recordField) {
        BiConsumer<RecordConsumer, Object> elemConsumer = this.buildCollectionWriter(parametized);
        if (elemConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in collection");
        }
        return CollectionsWriters.twoLevelCollectionRecordFieldWriterFactory(this.recordConsumer, recordField, elemConsumer);
    }

    private Consumer<Object> createThreeLevelStructureWriter(FieldType parametized, RecordField recordField) {
        BiConsumer<RecordConsumer, Object> elemConsumer = this.buildCollectionWriter(parametized);
        if (elemConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in collection");
        }
        return CollectionsWriters.threeLevelCollectionRecordFieldWriterFactory(this.recordConsumer, recordField, elemConsumer);
    }

    private BiConsumer<RecordConsumer, Object> buildCollectionWriter(FieldType parametized) {
        if (parametized instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)parametized;
            Consumer<Object> childWriter = this.createCollectionWriter(collectionType, null);
            return (consumer, v) -> childWriter.accept(v);
        }
        if (parametized instanceof MapType) {
            MapType mapType = (MapType)parametized;
            Consumer<Object> childWriter = this.createMapStructureWriter(mapType, null);
            return (consumer, v) -> childWriter.accept(v);
        }
        return ModelFieldsWriter.buildSimpleElementConsumer(parametized, this.recordConsumer, this.carpetConfiguration);
    }

    private Consumer<Object> createMapStructureWriter(MapType mapType, RecordField recordField) {
        BiConsumer<RecordConsumer, Object> keyConsumer = ModelFieldsWriter.buildSimpleElementConsumer(mapType.keyType(), this.recordConsumer, this.carpetConfiguration);
        BiConsumer<RecordConsumer, Object> valueConsumer = this.buildCollectionWriter(mapType.valueType());
        return CollectionsWriters.mapRecordFieldWriterFactory(this.recordConsumer, recordField, keyConsumer, valueConsumer);
    }
}

