/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.annotation.PrecisionScale;
import com.jerolba.carpet.annotation.Rounding;
import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.write.BigDecimalWrite;
import com.jerolba.carpet.impl.write.CarpetRecordWriter;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.DecimalConfig;
import com.jerolba.carpet.impl.write.EnumsValues;
import com.jerolba.carpet.impl.write.TimeWrite;
import com.jerolba.carpet.impl.write.UuidWrite;
import java.time.LocalDate;
import java.util.function.BiConsumer;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;

class FieldsWriter {
    private FieldsWriter() {
    }

    public static BiConsumer<RecordConsumer, Object> buildSimpleElementConsumer(JavaType type, RecordConsumer recordConsumer, CarpetWriteConfiguration carpetConfiguration) {
        if (type.isInteger()) {
            return (consumer, v) -> consumer.addInteger(((Integer)v).intValue());
        }
        if (type.isString()) {
            return (consumer, v) -> consumer.addBinary(Binary.fromString((String)((String)v)));
        }
        if (type.isBoolean()) {
            return (consumer, v) -> consumer.addBoolean(((Boolean)v).booleanValue());
        }
        if (type.isLong()) {
            return (consumer, v) -> consumer.addLong(((Long)v).longValue());
        }
        if (type.isDouble()) {
            return (consumer, v) -> consumer.addDouble(((Double)v).doubleValue());
        }
        if (type.isFloat()) {
            return (consumer, v) -> consumer.addFloat(((Float)v).floatValue());
        }
        if (type.isShort() || type.isByte()) {
            return (consumer, v) -> consumer.addInteger(((Number)v).intValue());
        }
        if (type.isBinary()) {
            return (consumer, v) -> consumer.addBinary((Binary)v);
        }
        if (type.isEnum()) {
            EnumsValues enumValues = new EnumsValues(type.getJavaType());
            return (consumer, v) -> consumer.addBinary(enumValues.getValue(v));
        }
        if (type.isUuid()) {
            return (consumer, v) -> consumer.addBinary(UuidWrite.uuidToBinary(v));
        }
        if (type.isLocalDate()) {
            return (consumer, v) -> consumer.addInteger((int)((LocalDate)v).toEpochDay());
        }
        if (type.isLocalTime()) {
            return TimeWrite.localTimeConsumer(carpetConfiguration.defaultTimeUnit());
        }
        if (type.isLocalDateTime()) {
            return TimeWrite.localDateTimeConsumer(carpetConfiguration.defaultTimeUnit());
        }
        if (type.isInstant()) {
            return TimeWrite.instantCosumer(carpetConfiguration.defaultTimeUnit());
        }
        if (type.isBigDecimal()) {
            DecimalConfig decimalConfig = BigDecimalWrite.buildDecimalConfig(type.getAnnotation(PrecisionScale.class), type.getAnnotation(Rounding.class), carpetConfiguration.decimalConfig());
            BigDecimalWrite bigDecimalWrite = new BigDecimalWrite(decimalConfig);
            return bigDecimalWrite::write;
        }
        if (type.isRecord()) {
            CarpetRecordWriter recordWriter = new CarpetRecordWriter(recordConsumer, type.getJavaType(), carpetConfiguration);
            return (consumer, v) -> {
                consumer.startGroup();
                recordWriter.write(v);
                consumer.endGroup();
            };
        }
        return null;
    }
}

