/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resource;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.classloader.ClassLoaderHelper;
import com.helger.base.classloader.IHasClassLoader;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.url.URLHelper;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.URLResource;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class ClassPathResource
implements IReadableResource,
IHasClassLoader {
    public static final String CLASSPATH_PREFIX_LONG = "classpath:";
    public static final String CLASSPATH_PREFIX_SHORT = "cp:";
    private String m_sPath;
    private final WeakReference<ClassLoader> m_aClassLoader;
    private boolean m_bURLResolved = false;
    private URL m_aURL;

    public ClassPathResource(@NonNull URL uRL) {
        this(uRL, null);
    }

    public ClassPathResource(@NonNull URL uRL, @Nullable ClassLoader classLoader) {
        this(uRL.toExternalForm(), classLoader);
    }

    public ClassPathResource(@NonNull @Nonempty String string) {
        this(string, null);
    }

    public ClassPathResource(@NonNull @Nonempty String string, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        this.m_sPath = ClassPathResource.getWithoutClassPathPrefix(string);
        if (StringHelper.isEmpty((String)this.m_sPath)) {
            throw new IllegalArgumentException("No path specified after prefix: " + string);
        }
        this.m_aClassLoader = classLoader == null ? null : new WeakReference<ClassLoader>(classLoader);
    }

    private void writeObject(@NonNull ObjectOutputStream objectOutputStream) throws IOException {
        if (this.m_aClassLoader != null) {
            throw new IOException("Cannot serialize a ClassPathResource that has a specific ClassLoader!");
        }
        StreamHelper.writeSafeUTF((DataOutput)objectOutputStream, (String)this.m_sPath);
    }

    private void readObject(@NonNull ObjectInputStream objectInputStream) throws IOException {
        this.m_sPath = StreamHelper.readSafeUTF((DataInput)objectInputStream);
    }

    public static @Nullable String getWithoutClassPathPrefix(@Nullable String string) {
        if (StringHelper.startsWith((String)string, (String)CLASSPATH_PREFIX_LONG)) {
            return string.substring(CLASSPATH_PREFIX_LONG.length());
        }
        if (StringHelper.startsWith((String)string, (String)CLASSPATH_PREFIX_SHORT)) {
            return string.substring(CLASSPATH_PREFIX_SHORT.length());
        }
        return string;
    }

    public static boolean isExplicitClassPathResource(@Nullable String string) {
        return StringHelper.startsWith((String)string, (String)CLASSPATH_PREFIX_LONG) || StringHelper.startsWith((String)string, (String)CLASSPATH_PREFIX_SHORT);
    }

    public @Nullable ClassLoader getClassLoader() {
        return this.m_aClassLoader == null ? null : (ClassLoader)this.m_aClassLoader.get();
    }

    @Override
    public @NonNull String getResourceID() {
        URL uRL = this.getAsURL();
        return uRL == null ? this.m_sPath : uRL.toExternalForm();
    }

    @Override
    public @NonNull @Nonempty String getPath() {
        return this.m_sPath;
    }

    private static @Nullable InputStream _getInputStream(@NonNull @Nonempty String string, @Nullable URL uRL, @Nullable ClassLoader classLoader) {
        InputStream inputStream = null;
        if (classLoader != null) {
            inputStream = ClassLoaderHelper.getResourceAsStream((ClassLoader)classLoader, (String)string);
        } else if (uRL != null) {
            inputStream = URLResource.getInputStream(uRL);
        }
        return inputStream;
    }

    public static @Nullable InputStream getInputStream(@NonNull @Nonempty String string) {
        URL uRL = URLHelper.getClassPathURL((String)string);
        return ClassPathResource._getInputStream(string, uRL, null);
    }

    public static @Nullable InputStream getInputStream(@NonNull @Nonempty String string, @NonNull ClassLoader classLoader) {
        URL uRL = ClassLoaderHelper.getResource((ClassLoader)classLoader, (String)string);
        return ClassPathResource._getInputStream(string, uRL, null);
    }

    public @Nullable InputStream getInputStream() {
        URL uRL = this.getAsURL();
        return ClassPathResource._getInputStream(this.m_sPath, uRL, this.getClassLoader());
    }

    public final boolean isReadMultiple() {
        return true;
    }

    public @Nullable InputStream getInputStreamNoCache(@NonNull ClassLoader classLoader) {
        URL uRL = this.getAsURLNoCache(classLoader);
        return ClassPathResource._getInputStream(this.m_sPath, uRL, classLoader);
    }

    public @Nullable Reader getReaderNoCache(@NonNull ClassLoader classLoader, @NonNull Charset charset) {
        return StreamHelper.createReader((InputStream)this.getInputStreamNoCache(classLoader), (Charset)charset);
    }

    @Override
    public boolean exists() {
        return this.getAsURL() != null;
    }

    private @Nullable URL _getAsURL() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return URLHelper.getClassPathURL((String)this.m_sPath);
        }
        String string = this.m_sPath;
        return ClassLoaderHelper.getResource((ClassLoader)classLoader, (String)string);
    }

    public boolean existsNoCacheUsage() {
        return this._getAsURL() != null;
    }

    @Override
    public @Nullable URL getAsURL() {
        if (!this.m_bURLResolved) {
            this.m_aURL = this._getAsURL();
            this.m_bURLResolved = true;
        }
        return this.m_aURL;
    }

    public @Nullable URL getAsURLNoCache(@NonNull ClassLoader classLoader) {
        String string = this.m_sPath;
        return ClassLoaderHelper.getResource((ClassLoader)classLoader, (String)string);
    }

    public static @Nullable File getAsFile(@NonNull @Nonempty String string) {
        URL uRL = URLHelper.getClassPathURL((String)string);
        return URLHelper.getAsFileOrNull((URL)uRL);
    }

    public static @Nullable File getAsFile(@NonNull @Nonempty String string, @NonNull ClassLoader classLoader) {
        URL uRL = ClassLoaderHelper.getResource((ClassLoader)classLoader, (String)string);
        return URLHelper.getAsFileOrNull((URL)uRL);
    }

    @Override
    public @Nullable File getAsFile() {
        URL uRL = this.getAsURL();
        return URLHelper.getAsFileOrNull((URL)uRL);
    }

    public @Nullable File getAsFileNoCache(@NonNull ClassLoader classLoader) {
        URL uRL = this.getAsURLNoCache(classLoader);
        return URLHelper.getAsFileOrNull((URL)uRL);
    }

    public boolean canRead() {
        return this.getAsURL() != null;
    }

    public boolean canReadNoCache(@NonNull ClassLoader classLoader) {
        return this.getAsURLNoCache(classLoader) != null;
    }

    @Override
    public @NonNull ClassPathResource getReadableCloneForPath(@NonNull String string) {
        return new ClassPathResource(string, this.getClassLoader());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ClassPathResource classPathResource = (ClassPathResource)object;
        String string = this.m_sPath;
        return EqualsHelper.equals((Object)string, (Object)classPathResource.m_sPath) && EqualsHelper.equals((Object)this.getClassLoader(), (Object)classPathResource.getClassLoader());
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPath).append((Object)this.getClassLoader()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("cpPath", (Object)this.m_sPath).appendIfNotNull("classLoader", (Object)this.getClassLoader()).append("urlResolved", this.m_bURLResolved).append("URL", (Object)this.m_aURL).getToString();
    }
}

