/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphiql.boot;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class GraphiQLController {
    @Value(value="${graphiql.endpoint:/graphql}")
    private String graphqlEndpoint;
    @Value(value="${graphiql.pageTitle:GraphiQL}")
    private String pageTitle;
    @Value(value="${graphiql.cdn.enabled:false}")
    private Boolean graphiqlCdnEnabled;
    @Value(value="${graphiql.cdn.version:0.11.11}")
    private String graphiqlCdnVersion;
    private String template;

    @PostConstruct
    public void loadTemplate() throws IOException {
        try (InputStream inputStream = new ClassPathResource("graphiql.html").getInputStream();){
            this.template = StreamUtils.copyToString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
    }

    @RequestMapping(value={"${graphiql.mapping:/graphiql}"})
    public void graphiql(HttpServletRequest request, HttpServletResponse response, @PathVariable Map<String, String> params) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        HashMap<String, String> replacements = new HashMap<String, String>();
        String graphiqlCssUrl = "/vendor/graphiql.min.css";
        String graphiqlJsUrl = "/vendor/graphiql.min.js";
        if (this.graphiqlCdnEnabled.booleanValue() && StringUtils.isNotBlank((CharSequence)this.graphiqlCdnVersion)) {
            graphiqlCssUrl = "//cdnjs.cloudflare.com/ajax/libs/graphiql/" + this.graphiqlCdnVersion + "/graphiql.min.css";
            graphiqlJsUrl = "//cdnjs.cloudflare.com/ajax/libs/graphiql/" + this.graphiqlCdnVersion + "/graphiql.min.js";
        }
        String endpoint = this.constructGraphQlEndpoint(params);
        if (StringUtils.isNotBlank((CharSequence)request.getContextPath()) && !endpoint.startsWith(request.getContextPath())) {
            endpoint = request.getContextPath() + endpoint;
        }
        replacements.put("graphqlEndpoint", endpoint);
        replacements.put("pageTitle", this.pageTitle);
        replacements.put("graphiqlCssUrl", graphiqlCssUrl);
        replacements.put("graphiqlJsUrl", graphiqlJsUrl);
        String populatedTemplate = StrSubstitutor.replace((Object)this.template, replacements);
        if (StringUtils.isNotBlank((CharSequence)request.getContextPath())) {
            String vendorPathWithContext = String.format("%s/vendor", request.getContextPath());
            populatedTemplate = populatedTemplate.replaceAll("src=\"/vendor", "src=\"" + vendorPathWithContext).replaceAll("href=\"/vendor", "href=\"" + vendorPathWithContext);
        }
        response.getOutputStream().write(populatedTemplate.getBytes(Charset.defaultCharset()));
    }

    private String constructGraphQlEndpoint(@RequestParam Map<String, String> params) {
        String endpoint = this.graphqlEndpoint;
        for (Map.Entry<String, String> param : params.entrySet()) {
            endpoint = endpoint.replaceAll("\\{" + param.getKey() + "}", param.getValue());
        }
        return endpoint;
    }
}

