/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.validation.ValidationMode;
import com.googlecode.flyway.maven.AbstractMigrationLoadingMojo;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrateMojo
extends AbstractMigrationLoadingMojo {
    private static final String PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    private boolean ignoreFailedFutureMigration;
    private Map<String, String> placeholders;
    private String placeholderPrefix;
    private String placeholderSuffix;
    @Deprecated
    private boolean disableInitCheck;
    private boolean initOnMigrate;
    @Deprecated
    private String validationMode;
    private boolean validateOnMigrate;

    @Override
    protected void doExecuteWithMigrationConfig(Flyway flyway) throws Exception {
        flyway.setIgnoreFailedFutureMigration(this.ignoreFailedFutureMigration);
        HashMap<String, String> mergedPlaceholders = new HashMap<String, String>();
        MigrateMojo.addPlaceholdersFromProperties(mergedPlaceholders, this.mavenProject.getProperties());
        MigrateMojo.addPlaceholdersFromProperties(mergedPlaceholders, System.getProperties());
        if (this.placeholders != null) {
            mergedPlaceholders.putAll(this.placeholders);
        }
        flyway.setPlaceholders(mergedPlaceholders);
        if (this.placeholderPrefix != null) {
            flyway.setPlaceholderPrefix(this.placeholderPrefix);
        }
        if (this.placeholderSuffix != null) {
            flyway.setPlaceholderSuffix(this.placeholderSuffix);
        }
        flyway.setDisableInitCheck(this.disableInitCheck);
        flyway.setInitOnMigrate(this.initOnMigrate);
        if (this.validationMode != null) {
            flyway.setValidationMode(ValidationMode.valueOf((String)this.validationMode.toUpperCase()));
        }
        flyway.setValidateOnMigrate(this.validateOnMigrate);
        if (flyway.info().all().length == 0) {
            this.log.warn("Possible solution: run mvn compile first so Flyway can find the migrations");
        }
        flyway.migrate();
    }

    private static void addPlaceholdersFromProperties(Map<String, String> placeholders, Properties properties) {
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            if (!propertyName.startsWith(PLACEHOLDERS_PROPERTY_PREFIX) || propertyName.length() <= PLACEHOLDERS_PROPERTY_PREFIX.length()) continue;
            String placeholderName = propertyName.substring(PLACEHOLDERS_PROPERTY_PREFIX.length());
            String placeholderValue = properties.getProperty(propertyName);
            placeholders.put(placeholderName, placeholderValue);
        }
    }
}

