/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.maps.model.PriceLevel;
import java.io.IOException;

public class PriceLevelAdapter
extends TypeAdapter<PriceLevel> {
    public PriceLevel read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        if (reader.peek() == JsonToken.NUMBER) {
            int priceLevel = reader.nextInt();
            switch (priceLevel) {
                case 0: {
                    return PriceLevel.FREE;
                }
                case 1: {
                    return PriceLevel.INEXPENSIVE;
                }
                case 2: {
                    return PriceLevel.MODERATE;
                }
                case 3: {
                    return PriceLevel.EXPENSIVE;
                }
                case 4: {
                    return PriceLevel.VERY_EXPENSIVE;
                }
            }
        }
        return PriceLevel.UNKNOWN;
    }

    public void write(JsonWriter writer, PriceLevel value) throws IOException {
        throw new UnsupportedOperationException("Unimplemented method");
    }
}

