/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CommonResources;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.AbstractNativeScrollbar;
import com.google.gwt.user.client.ui.HorizontalScrollbar;
import com.google.gwt.user.client.ui.ScrollImpl;

public class NativeHorizontalScrollbar
extends AbstractNativeScrollbar
implements HorizontalScrollbar {
    private static Resources DEFAULT_RESOURCES;
    private static NativeHorizontalScrollbarUiBinder uiBinder;
    @UiField
    Element contentDiv;
    @UiField
    Element scrollable;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public NativeHorizontalScrollbar() {
        this(NativeHorizontalScrollbar.getDefaultResources());
    }

    public NativeHorizontalScrollbar(Resources resources) {
        this.setElement((Element)uiBinder.createAndBindUi(this));
        this.getElement().addClassName(CommonResources.getInlineBlockStyle());
        int n = this.getNativeHeight();
        this.setHeight(new StringBuilder(13).append(n).append("px").toString());
        Style style = resources.nativeHorizontalScrollbarStyle();
        style.ensureInjected();
        this.getScrollableElement().addClassName(style.nativeHorizontalScrollbar());
        ScrollImpl.get().initialize(this.scrollable, this.contentDiv);
    }

    @Override
    public int getHorizontalScrollPosition() {
        return this.getScrollableElement().getScrollLeft();
    }

    @Override
    public int getMaximumHorizontalScrollPosition() {
        return ScrollImpl.get().getMaximumHorizontalScrollPosition(this.getScrollableElement());
    }

    @Override
    public int getMinimumHorizontalScrollPosition() {
        return ScrollImpl.get().getMinimumHorizontalScrollPosition(this.getScrollableElement());
    }

    @Override
    public int getScrollWidth() {
        return this.contentDiv.getOffsetWidth();
    }

    @Override
    public void setHorizontalScrollPosition(int position) {
        this.getScrollableElement().setScrollLeft(position);
    }

    @Override
    public void setScrollWidth(int width) {
        this.contentDiv.getStyle().setWidth(width, Style.Unit.PX);
    }

    protected int getNativeHeight() {
        return NativeHorizontalScrollbar.getNativeScrollbarHeight();
    }

    @Override
    protected Element getScrollableElement() {
        return this.scrollable;
    }

    static {
        uiBinder = (NativeHorizontalScrollbarUiBinder)GWT.create(NativeHorizontalScrollbarUiBinder.class);
    }

    public static interface StyleTransparant
    extends Style {
        public static final String DEFAULT_CSS = "com/google/gwt/user/client/ui/NativeHorizontalScrollbarTransparent.css";
    }

    @CssResource.ImportedWithPrefix(value="gwt-NativeHorizontalScrollbar")
    public static interface Style
    extends CssResource {
        public static final String DEFAULT_CSS = "com/google/gwt/user/client/ui/NativeHorizontalScrollbar.css";

        public String nativeHorizontalScrollbar();
    }

    public static interface ResourcesTransparant
    extends Resources {
        @Override
        @ClientBundle.Source(value={"com/google/gwt/user/client/ui/NativeHorizontalScrollbarTransparent.css"})
        public Style nativeHorizontalScrollbarStyle();
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"com/google/gwt/user/client/ui/NativeHorizontalScrollbar.css"})
        public Style nativeHorizontalScrollbarStyle();
    }

    static interface NativeHorizontalScrollbarUiBinder
    extends UiBinder<Element, NativeHorizontalScrollbar> {
    }
}

