/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.maven;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ProcessUtils {
    public static void close(Process[] processes) {
        for (Process process : processes) {
            if (process == null) continue;
            try {
                process.getErrorStream().close();
                process.getOutputStream().close();
                process.getInputStream().close();
            }
            catch (IOException e) {
                System.out.println("Exception caught when closing process input/output stream(s)");
                e.printStackTrace();
            }
            process.destroy();
        }
    }

    public static BufferedReader getInputStream(Process p) {
        InputStream inputStream = p.getInputStream();
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    public static void closeProcessAndStreams(Process p, Closeable[] streams) {
        for (Closeable stream : streams) {
            if (stream == null) continue;
            try {
                stream.close();
            }
            catch (IOException e) {
                System.out.println("Error closing stream:");
                e.printStackTrace();
            }
        }
        if (p == null) {
            return;
        }
        p.destroy();
    }
}

