/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryReadStub;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1.stub.GrpcBigQueryReadCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcBigQueryReadStub
extends BigQueryReadStub {
    private static final MethodDescriptor<CreateReadSessionRequest, ReadSession> createReadSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1.BigQueryRead/CreateReadSession").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateReadSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadSession.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ReadRowsRequest, ReadRowsResponse> readRowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.cloud.bigquery.storage.v1.BigQueryRead/ReadRows").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadRowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadRowsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1.BigQueryRead/SplitReadStream").setRequestMarshaller(ProtoUtils.marshaller((Message)SplitReadStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SplitReadStreamResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateReadSessionRequest, ReadSession> createReadSessionCallable;
    private final ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable;
    private final UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBigQueryReadStub create(BigQueryReadStubSettings settings) throws IOException {
        return new GrpcBigQueryReadStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBigQueryReadStub create(ClientContext clientContext) throws IOException {
        return new GrpcBigQueryReadStub(BigQueryReadStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBigQueryReadStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBigQueryReadStub(BigQueryReadStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBigQueryReadStub(BigQueryReadStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBigQueryReadCallableFactory());
    }

    protected GrpcBigQueryReadStub(BigQueryReadStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createReadSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createReadSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("read_session.table", String.valueOf(request.getReadSession().getTable()));
            return builder.build();
        }).build();
        GrpcCallSettings readRowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readRowsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("read_stream", String.valueOf(request.getReadStream()));
            return builder.build();
        }).build();
        GrpcCallSettings splitReadStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(splitReadStreamMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createReadSessionCallable = callableFactory.createUnaryCallable(createReadSessionTransportSettings, settings.createReadSessionSettings(), clientContext);
        this.readRowsCallable = callableFactory.createServerStreamingCallable(readRowsTransportSettings, settings.readRowsSettings(), clientContext);
        this.splitReadStreamCallable = callableFactory.createUnaryCallable(splitReadStreamTransportSettings, settings.splitReadStreamSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateReadSessionRequest, ReadSession> createReadSessionCallable() {
        return this.createReadSessionCallable;
    }

    @Override
    public ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        return this.readRowsCallable;
    }

    @Override
    public UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamCallable() {
        return this.splitReadStreamCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

