/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import java.util.ConcurrentModificationException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.store.appengine.FatalNucleusUserException;
import org.datanucleus.store.query.QueryTimeoutException;

public final class DatastoreExceptionTranslator {
    private DatastoreExceptionTranslator() {
    }

    public static NucleusException wrapIllegalArgumentException(IllegalArgumentException e) {
        return new FatalNucleusUserException("Illegal argument", e);
    }

    public static NucleusDataStoreException wrapDatastoreFailureException(DatastoreFailureException e) {
        return new NucleusDataStoreException("Datastore Failure", (Throwable)e);
    }

    static NucleusDataStoreException wrapConcurrentModificationException(ConcurrentModificationException e) {
        return new NucleusDataStoreException("Concurrent Modification", (Throwable)e);
    }

    static NucleusObjectNotFoundException wrapEntityNotFoundException(EntityNotFoundException e, Key key) {
        return new NucleusObjectNotFoundException("Could not retrieve entity of kind " + key.getKind() + " with key " + key);
    }

    public static QueryTimeoutException wrapDatastoreTimeoutExceptionForQuery(final DatastoreTimeoutException e) {
        QueryTimeoutException qte = new QueryTimeoutException(e.getMessage()){

            public Throwable getCause() {
                return e;
            }
        };
        return qte;
    }
}

