/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.taskqueue.DeferredTask;
import com.google.appengine.api.taskqueue.dev.LocalTaskQueue;
import com.google.appengine.api.taskqueue.dev.LocalTaskQueueCallback;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.testing.EnvSettingTaskqueueCallback;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class LocalTaskQueueTestConfig
implements LocalServiceTestConfig {
    private Boolean disableAutoTaskExecution = true;
    private String queueXmlPath;
    private Class<? extends LocalTaskQueueCallback> callbackClass;
    private boolean shouldCopyApiProxyEnvironment = false;
    private CountDownLatch taskExecutionLatch;

    public LocalTaskQueueTestConfig setDisableAutoTaskExecution(boolean disableAutoTaskExecution) {
        this.disableAutoTaskExecution = disableAutoTaskExecution;
        return this;
    }

    public LocalTaskQueueTestConfig setQueueXmlPath(String queueXmlPath) {
        this.queueXmlPath = queueXmlPath;
        return this;
    }

    public LocalTaskQueueTestConfig setCallbackClass(Class<? extends LocalTaskQueueCallback> callbackClass) {
        this.callbackClass = callbackClass;
        return this;
    }

    public LocalTaskQueueTestConfig setShouldCopyApiProxyEnvironment(boolean b) {
        this.shouldCopyApiProxyEnvironment = b;
        return this;
    }

    public LocalTaskQueueTestConfig setTaskExecutionLatch(CountDownLatch latch) {
        this.taskExecutionLatch = latch;
        return this;
    }

    @Override
    public void setUp() {
        ApiProxyLocal proxy = LocalServiceTestHelper.getApiProxyLocal();
        proxy.setProperty("task_queue.disable_auto_task_execution", this.disableAutoTaskExecution.toString());
        if (this.queueXmlPath != null) {
            proxy.setProperty("task_queue.queue_xml_path", this.queueXmlPath);
        }
        if (this.callbackClass != null) {
            String callbackName;
            if (!this.disableAutoTaskExecution.booleanValue()) {
                EnvSettingTaskqueueCallback.setProxyProperties(proxy, this.callbackClass, this.shouldCopyApiProxyEnvironment);
                if (this.taskExecutionLatch != null) {
                    EnvSettingTaskqueueCallback.setTaskExecutionLatch(this.taskExecutionLatch);
                }
                callbackName = EnvSettingTaskqueueCallback.class.getName();
            } else {
                callbackName = this.callbackClass.getName();
            }
            proxy.setProperty("task_queue.callback_class", callbackName);
        }
    }

    @Override
    public void tearDown() {
        LocalTaskQueue ltq = LocalTaskQueueTestConfig.getLocalTaskQueue();
        if (ltq != null) {
            for (String queueName : ltq.getQueueStateInfo().keySet()) {
                ltq.flushQueue(queueName);
            }
        }
    }

    public static LocalTaskQueue getLocalTaskQueue() {
        return (LocalTaskQueue)LocalServiceTestHelper.getLocalService("taskqueue");
    }

    public static final class TaskCountDownLatch
    extends CountDownLatch {
        private int initialCount;
        private CountDownLatch latch;

        public TaskCountDownLatch(int count) {
            super(count);
            this.reset(count);
        }

        @Override
        public long getCount() {
            return this.latch.getCount();
        }

        @Override
        public String toString() {
            return this.latch.toString();
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }

        @Override
        public void countDown() {
            this.latch.countDown();
        }

        public void awaitAndReset() throws InterruptedException {
            this.awaitAndReset(this.initialCount);
        }

        public void awaitAndReset(int count) throws InterruptedException {
            this.await();
            this.reset(count);
        }

        public boolean awaitAndReset(long timeout, TimeUnit unit) throws InterruptedException {
            return this.awaitAndReset(timeout, unit, this.initialCount);
        }

        public boolean awaitAndReset(long timeout, TimeUnit unit, int count) throws InterruptedException {
            boolean result = this.await(timeout, unit);
            this.reset(count);
            return result;
        }

        public void reset() {
            this.reset(this.initialCount);
        }

        public void reset(int count) {
            this.initialCount = count;
            this.latch = new CountDownLatch(count);
        }
    }

    public static class DeferredTaskCallback
    implements LocalTaskQueueCallback {
        public void initialize(Map<String, String> properties) {
        }

        public int execute(URLFetchServicePb.URLFetchRequest req) {
            for (URLFetchServicePb.URLFetchRequest.Header header : req.getHeaderList()) {
                if (!header.getKey().equals("content-type") || !"application/x-binary-app-engine-java-runnable-task".equals(header.getValue())) continue;
                ByteString payload = req.getPayload();
                ByteArrayInputStream bais = new ByteArrayInputStream(payload.toByteArray());
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    DeferredTask deferredTask = (DeferredTask)ois.readObject();
                    deferredTask.run();
                    return 200;
                }
                catch (Exception e) {
                    return 500;
                }
            }
            return this.executeNonDeferredRequest(req);
        }

        protected int executeNonDeferredRequest(URLFetchServicePb.URLFetchRequest req) {
            return 200;
        }
    }
}

