/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.search;

import com.google.appengine.repackaged.org.apache.lucene.index.IndexReader;
import com.google.appengine.repackaged.org.apache.lucene.search.Collector;
import com.google.appengine.repackaged.org.apache.lucene.search.DocIdSet;
import com.google.appengine.repackaged.org.apache.lucene.search.DocIdSetIterator;
import com.google.appengine.repackaged.org.apache.lucene.search.Filter;
import com.google.appengine.repackaged.org.apache.lucene.search.IndexSearcher;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.Scorer;
import com.google.appengine.repackaged.org.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.BitSet;

public class QueryWrapperFilter
extends Filter {
    private Query query;

    public QueryWrapperFilter(Query query) {
        this.query = query;
    }

    public BitSet bits(IndexReader reader) throws IOException {
        final BitSet bits = new BitSet(reader.maxDoc());
        new IndexSearcher(reader).search(this.query, new Collector(){
            private int base = 0;

            public void setScorer(Scorer scorer) throws IOException {
            }

            public final void collect(int doc) {
                bits.set(doc + this.base);
            }

            public void setNextReader(IndexReader reader, int docBase) {
                this.base = docBase;
            }

            public boolean acceptsDocsOutOfOrder() {
                return true;
            }
        });
        return bits;
    }

    public DocIdSet getDocIdSet(final IndexReader reader) throws IOException {
        final Weight weight = this.query.weight(new IndexSearcher(reader));
        return new DocIdSet(){

            public DocIdSetIterator iterator() throws IOException {
                return weight.scorer(reader, true, false);
            }

            public boolean isCacheable() {
                return false;
            }
        };
    }

    public String toString() {
        return "QueryWrapperFilter(" + this.query + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueryWrapperFilter)) {
            return false;
        }
        return this.query.equals(((QueryWrapperFilter)o).query);
    }

    public int hashCode() {
        return this.query.hashCode() ^ 0x923F64B9;
    }
}

