/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket.dev;

import com.google.appengine.api.socket.SocketServicePb;
import com.google.appengine.api.socket.dev.DatagramSocketImplAccessor;
import com.google.appengine.api.socket.dev.LocalSocket;
import com.google.appengine.api.socket.dev.LocalSocketService;
import com.google.appengine.api.socket.dev.SocketPermissions;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class LocalDatagramSocket
extends LocalSocket {
    DatagramSocketImplAccessor accessor = DatagramSocketImplAccessor.newSocketImplAccessor();
    private InetAddress connectedAddress = null;
    private int connectedPort = -1;

    LocalDatagramSocket(LocalSocketService socketService) {
        super(socketService);
        try {
            this.accessor.create();
        }
        catch (SocketException e) {
            throw this.newAppExceptionAndClose(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE, "Failed to create datagram socket.");
        }
    }

    DatagramSocketImplAccessor getImpl() {
        return this.accessor;
    }

    @Override
    public IOException close() {
        this.socketService.removeSocket(this.getSocketDescriptor());
        this.accessor.close();
        return null;
    }

    @Override
    public SocketServicePb.BindReply bind(SocketServicePb.BindRequest request) {
        this.bind(request.getProxyExternalIp());
        return new SocketServicePb.BindReply();
    }

    @Override
    public SocketServicePb.GetSocketNameReply getSocketName(SocketServicePb.GetSocketNameRequest request) {
        SocketServicePb.GetSocketNameReply reply = new SocketServicePb.GetSocketNameReply();
        try {
            reply.getMutableProxyExternalIp().setPackedAddressAsBytes(this.addrAsBytes((InetAddress)this.getImpl().getOption(15))).setPort(this.getImpl().getLocalPort());
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
        return reply;
    }

    @Override
    public SocketServicePb.GetPeerNameReply getPeerName(SocketServicePb.GetPeerNameRequest request) {
        if (this.connectedAddress == null) {
            throw this.newSystemAppExceptionAndClose("Socket is not connected.", SocketServicePb.RemoteSocketServiceError.SystemError.SYS_ENOTCONN);
        }
        return new SocketServicePb.GetPeerNameReply().setPeerIp(this.toAddressPort(this.connectedAddress, this.connectedPort));
    }

    @Override
    public SocketServicePb.ConnectReply connect(SocketServicePb.ConnectRequest request) {
        this.connect(request.getRemoteIp(), request.getTimeoutSeconds());
        return new SocketServicePb.ConnectReply();
    }

    @Override
    public SocketServicePb.ListenReply listen(SocketServicePb.ListenRequest request) {
        throw this.newNotImplementedException("listen");
    }

    @Override
    public SocketServicePb.AcceptReply accept(SocketServicePb.AcceptRequest request) {
        throw this.newNotImplementedException("accept");
    }

    @Override
    public SocketServicePb.ShutDownReply shutDown(SocketServicePb.ShutDownRequest request) {
        throw this.newNotImplementedException("shutDown");
    }

    @Override
    public SocketServicePb.CloseReply close(SocketServicePb.CloseRequest request) {
        this.close();
        return new SocketServicePb.CloseReply();
    }

    @Override
    public SocketServicePb.SendReply send(SocketServicePb.SendRequest request) {
        DatagramPacket packet;
        SocketPermissions.getSocketPermissions().checkConnect();
        byte[] data = request.getDataAsBytes();
        if (request.hasSendTo()) {
            try {
                packet = new DatagramPacket(data, 0, data.length, InetAddress.getByAddress(request.getSendTo().getPackedAddressAsBytes()), request.getSendTo().getPort());
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        } else {
            packet = new DatagramPacket(data, data.length);
        }
        try {
            this.getImpl().send(packet);
        }
        catch (IOException e) {
            throw this.newAppExceptionAndClose(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE, "send error: " + e.getMessage());
        }
        SocketServicePb.SendReply response = new SocketServicePb.SendReply();
        response.setDataSent(packet.getLength());
        return response;
    }

    @Override
    public SocketServicePb.ReceiveReply receive(SocketServicePb.ReceiveRequest request) {
        byte[] resultBuffer;
        SocketPermissions.getSocketPermissions().checkConnect();
        byte[] buffer = new byte[request.getDataSize()];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        try {
            if ((request.getFlags() & SocketServicePb.ReceiveRequest.Flags.MSG_PEEK.getValue()) != 0) {
                this.getImpl().peekData(packet);
            } else {
                this.getImpl().receive(packet);
            }
        }
        catch (IOException e) {
            throw this.newAppExceptionAndClose(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE, "receive error: " + e.getMessage());
        }
        if (packet.getLength() == buffer.length) {
            resultBuffer = buffer;
        } else {
            resultBuffer = new byte[packet.getLength()];
            System.arraycopy(buffer, 0, resultBuffer, 0, packet.getLength());
        }
        return new SocketServicePb.ReceiveReply().setDataAsBytes(resultBuffer).setReceivedFrom(this.toAddressPort(packet.getAddress(), packet.getPort()));
    }

    private SocketServicePb.AddressPort toAddressPort(InetAddress address, int port) {
        return new SocketServicePb.AddressPort().setPackedAddressAsBytes(this.addrAsBytes(address)).setPort(port);
    }

    @Override
    public SocketServicePb.CreateSocketReply createSocket(SocketServicePb.CreateSocketRequest request) {
        SocketServicePb.CreateSocketReply response = new SocketServicePb.CreateSocketReply();
        response.setSocketDescriptor(this.getSocketDescriptor());
        this.socketFamily = request.getFamilyEnum();
        if (request.hasProxyExternalIp()) {
            this.bind(request.getProxyExternalIp());
        }
        if (request.hasListenBacklog()) {
            throw this.newAppExceptionAndClose(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE, "Cannot listen on a UDP socket. ");
        }
        if (request.hasRemoteIp()) {
            this.connect(request.getRemoteIp(), -1.0);
        }
        return response;
    }

    private void bind(SocketServicePb.AddressPort proxyExternalIp) {
        InetAddress address;
        int port = proxyExternalIp.getPort();
        try {
            address = InetAddress.getByAddress(proxyExternalIp.getPackedAddressAsBytes());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
        if (port != 0 || !address.isAnyLocalAddress()) {
            SocketPermissions.getSocketPermissions().checkBind();
        }
        try {
            this.getImpl().bind(proxyExternalIp.getPort(), address);
        }
        catch (IOException e) {
            throw this.newAppExceptionAndClose(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE, "bind error: " + e.getMessage());
        }
    }

    private void connect(SocketServicePb.AddressPort remoteIp, double timeOutSeconds) {
        SocketPermissions.getSocketPermissions().checkConnect();
        try {
            InetAddress address = InetAddress.getByAddress(remoteIp.getPackedAddressAsBytes());
            this.getImpl().connect(address, remoteIp.getPort());
            this.connectedAddress = address;
            this.connectedPort = remoteIp.getPort();
        }
        catch (ConnectException e) {
            throw this.newSystemAppExceptionAndClose("connect error: " + e.getMessage(), SocketServicePb.RemoteSocketServiceError.SystemError.SYS_ECONNREFUSED);
        }
        catch (IOException e) {
            throw this.newAppExceptionAndClose(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE, "connect error: " + e.getMessage());
        }
    }

    private ApiProxy.ApplicationException newSystemAppExceptionAndClose(String message, SocketServicePb.RemoteSocketServiceError.SystemError errno) {
        this.close();
        SocketServicePb.RemoteSocketServiceError serviceError = new SocketServicePb.RemoteSocketServiceError();
        serviceError.setErrorDetail(message).setSystemError(errno.getValue());
        return this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.SYSTEM_ERROR, serviceError.toFlatString());
    }
}

