/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.org.apache.lucene.analysis.Analyzer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.LetterTokenizer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.cjk.CJKTokenizer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.miscellaneous.EmptyTokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.standard.StandardFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TermAttribute;
import com.google.apphosting.api.AppEngineInternal;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@AppEngineInternal
public class WordSeparatorAnalyzer
extends Analyzer {
    static final Logger LOG = Logger.getLogger(WordSeparatorAnalyzer.class.getCanonicalName());
    static final ImmutableSet<Character> WORD_SEPARATORS = ImmutableSet.of((Object)Character.valueOf('!'), (Object)Character.valueOf('\"'), (Object)Character.valueOf('%'), (Object)Character.valueOf('('), (Object)Character.valueOf(')'), (Object)Character.valueOf('*'), (Object[])new Character[]{Character.valueOf(','), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('['), Character.valueOf('\\'), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('`'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}'), Character.valueOf('~'), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\f'), Character.valueOf('\r'), Character.valueOf(' '), Character.valueOf('&'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf(';')});
    private static final float CJK_CHARACTER_THRESHOLD = 0.2f;
    private static final ImmutableSet<Character.UnicodeBlock> CJK_BLOCKS = ImmutableSet.of((Object)Character.UnicodeBlock.BOPOMOFO, (Object)Character.UnicodeBlock.BOPOMOFO_EXTENDED, (Object)Character.UnicodeBlock.CJK_COMPATIBILITY, (Object)Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS, (Object)Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS, (Object)Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, (Object[])new Character.UnicodeBlock[]{Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B, Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS, Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS, Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO, Character.UnicodeBlock.HANGUL_JAMO, Character.UnicodeBlock.HANGUL_SYLLABLES, Character.UnicodeBlock.HIRAGANA, Character.UnicodeBlock.IDEOGRAPHIC_DESCRIPTION_CHARACTERS, Character.UnicodeBlock.KANBUN, Character.UnicodeBlock.KANGXI_RADICALS, Character.UnicodeBlock.KATAKANA, Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS, Character.UnicodeBlock.TAI_XUAN_JING_SYMBOLS, Character.UnicodeBlock.YI_RADICALS, Character.UnicodeBlock.YI_SYLLABLES, Character.UnicodeBlock.YIJING_HEXAGRAM_SYMBOLS});
    private boolean detectCjk;

    static boolean isProbablyCjk(Reader reader, StringBuilder readerContents) throws IOException {
        int len;
        char[] buffer = new char[1024];
        long cjkChars = 0L;
        long totalChars = 0L;
        while ((len = reader.read(buffer)) >= 0) {
            totalChars += (long)len;
            readerContents.append(buffer, 0, len);
            for (int i = 0; i < len; ++i) {
                if (!CJK_BLOCKS.contains((Object)Character.UnicodeBlock.of(buffer[i]))) continue;
                ++cjkChars;
            }
        }
        return (float)cjkChars / (float)totalChars > 0.2f;
    }

    public WordSeparatorAnalyzer(boolean detectCjk) {
        this.detectCjk = detectCjk;
    }

    public WordSeparatorAnalyzer() {
        this(true);
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        StringBuilder readerContents = new StringBuilder();
        if (this.detectCjk) {
            boolean isCjk;
            try {
                isCjk = WordSeparatorAnalyzer.isProbablyCjk(reader, readerContents);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to read stream for tokenization.", e);
                return new EmptyTokenStream();
            }
            reader = new StringReader(readerContents.toString());
            if (isCjk) {
                return new CJKTokenizer(reader);
            }
        }
        WordSeparatorTokenizer tokenStream = new WordSeparatorTokenizer(reader);
        return new StandardFilter(tokenStream);
    }

    public static List<String> tokenList(String tokenizeString) {
        WordSeparatorAnalyzer analyzer = new WordSeparatorAnalyzer();
        TokenStream stream = analyzer.tokenStream("", new StringReader(tokenizeString));
        TermAttribute tokenTerm = (TermAttribute)stream.addAttribute(TermAttribute.class);
        ArrayList<String> tokens = new ArrayList<String>();
        try {
            while (stream.incrementToken()) {
                String term = tokenTerm.term();
                tokens.add(term);
            }
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
        return tokens;
    }

    public static String normalize(String tokenizeString) {
        StringBuilder builder = new StringBuilder();
        List<String> tokens = WordSeparatorAnalyzer.tokenList(tokenizeString);
        for (int i = 0; i < tokens.size(); ++i) {
            builder.append(tokens.get(i));
            if (i == tokens.size() - 1) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    public static String removeDiacriticals(String input) {
        String normalizedString = Normalizer.normalize(input, Normalizer.Form.NFD);
        return normalizedString.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    private class WordSeparatorTokenizer
    extends LetterTokenizer {
        public WordSeparatorTokenizer(Reader in) {
            super(in);
        }

        @Override
        protected char normalize(char c) {
            String cleaned = WordSeparatorAnalyzer.removeDiacriticals(Character.toString(c));
            if (cleaned.isEmpty()) {
                return '\'';
            }
            return Character.toLowerCase(cleaned.charAt(0));
        }

        @Override
        protected boolean isTokenChar(char c) {
            return !WORD_SEPARATORS.contains((Object)new Character(c));
        }
    }
}

