/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.GenericScorer;
import com.google.appengine.api.search.dev.MatchScorer;
import com.google.appengine.api.search.dev.SimpleScorer;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.search.IndexSearcher;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.apphosting.api.search.DocumentPb;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public abstract class Scorer {
    public abstract SearchResults search(IndexSearcher var1, Query var2, int var3, int var4) throws IOException;

    public static Scorer newInstance(SearchServicePb.SearchParams searchParams, Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes) {
        if (searchParams.getSortSpecCount() != 0) {
            return GenericScorer.newInstance(searchParams, fieldTypes);
        }
        if (!searchParams.hasScorerSpec()) {
            return new SimpleScorer(SimpleScorer.naturalOrder());
        }
        return MatchScorer.newInstance(searchParams, fieldTypes);
    }

    public static class SearchResults {
        public final Result[] results;
        public int totalHits;

        SearchResults(Result[] results, int totalHits) {
            this.results = results;
            this.totalHits = totalHits;
        }
    }

    public static abstract class Result {
        public final Document doc;

        public Result(Document doc) {
            this.doc = doc;
        }

        public abstract void addScores(SearchServicePb.SearchResult.Builder var1);
    }
}

