/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * The external service cost is a portion of the total cost, these costs are not additive with
 * total_bytes_billed. Moreover, this field only track external service costs that will show up as
 * BigQuery costs (e.g. training BigQuery ML job with google cloud CAIP or Automl Tables services),
 * not other costs which may be accrued by running the query (e.g. reading from Bigtable or Cloud
 * Storage). The external service costs with different billing sku (e.g. CAIP job is charged based
 * on VM usage) are converted to BigQuery billed_bytes and slot_ms with equivalent amount of US
 * dollars. Services may not directly correlate to these metrics, but these are the equivalents for
 * billing purposes. Output only.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExternalServiceCost extends com.google.api.client.json.GenericJson {

  /**
   * External service cost in terms of bigquery bytes billed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long bytesBilled;

  /**
   * External service cost in terms of bigquery bytes processed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long bytesProcessed;

  /**
   * External service name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalService;

  /**
   * Non-preemptable reserved slots used for external job. For example, reserved slots for Cloua AI
   * Platform job are the VM usages converted to BigQuery slot with equivalent mount of price.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long reservedSlotCount;

  /**
   * External service cost in terms of bigquery slot milliseconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long slotMs;

  /**
   * External service cost in terms of bigquery bytes billed.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBytesBilled() {
    return bytesBilled;
  }

  /**
   * External service cost in terms of bigquery bytes billed.
   * @param bytesBilled bytesBilled or {@code null} for none
   */
  public ExternalServiceCost setBytesBilled(java.lang.Long bytesBilled) {
    this.bytesBilled = bytesBilled;
    return this;
  }

  /**
   * External service cost in terms of bigquery bytes processed.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBytesProcessed() {
    return bytesProcessed;
  }

  /**
   * External service cost in terms of bigquery bytes processed.
   * @param bytesProcessed bytesProcessed or {@code null} for none
   */
  public ExternalServiceCost setBytesProcessed(java.lang.Long bytesProcessed) {
    this.bytesProcessed = bytesProcessed;
    return this;
  }

  /**
   * External service name.
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalService() {
    return externalService;
  }

  /**
   * External service name.
   * @param externalService externalService or {@code null} for none
   */
  public ExternalServiceCost setExternalService(java.lang.String externalService) {
    this.externalService = externalService;
    return this;
  }

  /**
   * Non-preemptable reserved slots used for external job. For example, reserved slots for Cloua AI
   * Platform job are the VM usages converted to BigQuery slot with equivalent mount of price.
   * @return value or {@code null} for none
   */
  public java.lang.Long getReservedSlotCount() {
    return reservedSlotCount;
  }

  /**
   * Non-preemptable reserved slots used for external job. For example, reserved slots for Cloua AI
   * Platform job are the VM usages converted to BigQuery slot with equivalent mount of price.
   * @param reservedSlotCount reservedSlotCount or {@code null} for none
   */
  public ExternalServiceCost setReservedSlotCount(java.lang.Long reservedSlotCount) {
    this.reservedSlotCount = reservedSlotCount;
    return this;
  }

  /**
   * External service cost in terms of bigquery slot milliseconds.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSlotMs() {
    return slotMs;
  }

  /**
   * External service cost in terms of bigquery slot milliseconds.
   * @param slotMs slotMs or {@code null} for none
   */
  public ExternalServiceCost setSlotMs(java.lang.Long slotMs) {
    this.slotMs = slotMs;
    return this;
  }

  @Override
  public ExternalServiceCost set(String fieldName, Object value) {
    return (ExternalServiceCost) super.set(fieldName, value);
  }

  @Override
  public ExternalServiceCost clone() {
    return (ExternalServiceCost) super.clone();
  }

}
