/*
 * Decompiled with CFR 0.152.
 */
package com.github.wvengen.maven.proguard;

import com.github.wvengen.maven.proguard.Assembly;
import com.github.wvengen.maven.proguard.Exclusion;
import com.github.wvengen.maven.proguard.Inclusion;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class ProGuardMojo
extends AbstractMojo {
    private boolean skip;
    private File proguardInclude;
    private String proguardVersion;
    private String[] options;
    private boolean obfuscate;
    private boolean includeDependency;
    private boolean includeDependencyInjar;
    private Assembly assembly;
    private List<String> libs;
    private List<String> exclusions;
    protected String injar;
    private boolean injarNotExistsSkip;
    protected String inFilter;
    protected String outjar;
    protected String outFilter;
    private boolean attach = false;
    private String attachArtifactType;
    private String attachArtifactClassifier;
    private boolean appendClassifier;
    private boolean addMavenDescriptor;
    protected File outputDirectory;
    protected MavenProject mavenProject;
    protected List<String> pluginArtifacts;
    private MavenProjectHelper projectHelper;
    private JarArchiver jarArchiver;
    protected MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    protected String maxMemory;
    protected String proguardMainClass = "proguard.ProGuard";
    protected String mappingFileName = "proguard_map.txt";
    protected String seedFileName = "proguard_seeds.txt";
    private Log log;

    private static String fileNameToString(String fileName) {
        return "'" + fileName + "'";
    }

    private static String fileToString(File file) {
        return ProGuardMojo.fileNameToString(file.toString());
    }

    private boolean useArtifactClassifier() {
        return this.appendClassifier && this.attachArtifactClassifier != null && this.attachArtifactClassifier.length() > 0;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StringBuffer filter;
        File outJarFile;
        boolean sameArtifact;
        this.log = this.getLog();
        if (this.skip) {
            this.log.info((CharSequence)"Bypass ProGuard processing because \"proguard.skip=true\"");
            return;
        }
        boolean mainIsJar = this.mavenProject.getPackaging().equals("jar");
        File inJarFile = new File(this.outputDirectory, this.injar);
        if (!inJarFile.exists()) {
            if (this.injarNotExistsSkip) {
                this.log.info((CharSequence)"Bypass ProGuard processing because \"injar\" dos not exist");
                return;
            }
            if (mainIsJar) {
                throw new MojoFailureException("Can't find file " + inJarFile);
            }
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new MojoFailureException("Can't create " + this.outputDirectory);
        }
        if (this.attach) {
            this.outjar = ProGuardMojo.nameNoType(this.injar);
            if (this.useArtifactClassifier()) {
                this.outjar = this.outjar + "-" + this.attachArtifactClassifier;
            }
            this.outjar = this.outjar + "." + this.attachArtifactType;
        }
        if (this.outjar != null && !this.outjar.equals(this.injar)) {
            sameArtifact = false;
            outJarFile = new File(this.outputDirectory, this.outjar).getAbsoluteFile();
            if (outJarFile.exists() && !ProGuardMojo.deleteFileOrDirectory(outJarFile)) {
                throw new MojoFailureException("Can't delete " + outJarFile);
            }
        } else {
            sameArtifact = true;
            outJarFile = inJarFile.getAbsoluteFile();
            File baseFile = inJarFile.isDirectory() ? new File(this.outputDirectory, ProGuardMojo.nameNoType(this.injar) + "_proguard_base") : new File(this.outputDirectory, ProGuardMojo.nameNoType(this.injar) + "_proguard_base.jar");
            if (baseFile.exists() && !ProGuardMojo.deleteFileOrDirectory(baseFile)) {
                throw new MojoFailureException("Can't delete " + baseFile);
            }
            if (inJarFile.exists() && !inJarFile.renameTo(baseFile)) {
                throw new MojoFailureException("Can't rename " + inJarFile);
            }
            inJarFile = baseFile;
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.log.isDebugEnabled()) {
            List dependancy = this.mavenProject.getCompileArtifacts();
            for (Artifact artifact : dependancy) {
                this.log.debug((CharSequence)("--- compile artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier() + " Scope:" + artifact.getScope()));
            }
            for (Artifact artifact : this.mavenProject.getArtifacts()) {
                this.log.debug((CharSequence)("--- artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier() + " Scope:" + artifact.getScope()));
            }
            for (Artifact artifact : this.mavenProject.getDependencies()) {
                this.log.debug((CharSequence)("--- dependency " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier() + " Scope:" + artifact.getScope()));
            }
        }
        HashSet<String> inPath = new HashSet<String>();
        boolean hasInclusionLibrary = false;
        if (this.assembly != null) {
            for (Inclusion inc : this.assembly.inclusions) {
                File file;
                if (!inc.library) {
                    file = ProGuardMojo.getClasspathElement(ProGuardMojo.getDependancy(inc, this.mavenProject), this.mavenProject);
                    inPath.add(file.toString());
                    this.log.debug((CharSequence)("--- ADD injars:" + inc.artifactId));
                    StringBuffer filter2 = new StringBuffer(ProGuardMojo.fileToString(file));
                    filter2.append("(!META-INF/MANIFEST.MF");
                    if (!this.addMavenDescriptor) {
                        filter2.append(",");
                        filter2.append("!META-INF/maven/**");
                    }
                    if (inc.filter != null) {
                        filter2.append(",").append(inc.filter);
                    }
                    filter2.append(")");
                    args.add("-injars");
                    args.add(filter2.toString());
                    continue;
                }
                hasInclusionLibrary = true;
                this.log.debug((CharSequence)("--- ADD libraryjars:" + inc.artifactId));
                file = ProGuardMojo.getClasspathElement(ProGuardMojo.getDependancy(inc, this.mavenProject), this.mavenProject);
                inPath.add(file.toString());
                args.add("-libraryjars");
                args.add(ProGuardMojo.fileToString(file));
            }
        }
        if (inJarFile.exists()) {
            args.add("-injars");
            filter = new StringBuffer(ProGuardMojo.fileToString(inJarFile));
            if (this.inFilter != null || !this.addMavenDescriptor) {
                filter.append("(");
                boolean coma = false;
                if (!this.addMavenDescriptor) {
                    coma = true;
                    filter.append("!META-INF/maven/**");
                }
                if (this.inFilter != null) {
                    if (coma) {
                        filter.append(",");
                    }
                    filter.append(this.inFilter);
                }
                filter.append(")");
            }
            args.add(filter.toString());
        }
        if (this.includeDependency) {
            List dependency = this.mavenProject.getCompileArtifacts();
            for (Artifact artifact : dependency) {
                if (this.isExclusion(artifact)) continue;
                File file = ProGuardMojo.getClasspathElement(artifact, this.mavenProject);
                if (inPath.contains(file.toString())) {
                    this.log.debug((CharSequence)("--- ignore library since one in injar:" + artifact.getArtifactId()));
                    continue;
                }
                if (this.includeDependencyInjar) {
                    this.log.debug((CharSequence)("--- ADD library as injars:" + artifact.getArtifactId()));
                    args.add("-injars");
                } else {
                    this.log.debug((CharSequence)("--- ADD libraryjars:" + artifact.getArtifactId()));
                    args.add("-libraryjars");
                }
                args.add(ProGuardMojo.fileToString(file));
            }
        }
        if (args.contains("-injars")) {
            args.add("-outjars");
            filter = new StringBuffer(ProGuardMojo.fileToString(outJarFile));
            if (this.outFilter != null) {
                filter.append("(").append(this.outFilter).append(")");
            }
            args.add(filter.toString());
        }
        if (!this.obfuscate) {
            args.add("-dontobfuscate");
        }
        if (this.proguardInclude != null) {
            if (this.proguardInclude.exists()) {
                args.add("-include");
                args.add(ProGuardMojo.fileToString(this.proguardInclude));
                this.log.debug((CharSequence)("proguardInclude " + this.proguardInclude));
            } else {
                this.log.debug((CharSequence)("proguardInclude config does not exists " + this.proguardInclude));
            }
        }
        if (this.libs != null) {
            for (String lib : this.libs) {
                args.add("-libraryjars");
                args.add(ProGuardMojo.fileNameToString(lib.toString()));
            }
        }
        args.add("-printmapping");
        args.add(ProGuardMojo.fileToString(new File(this.outputDirectory, this.mappingFileName).getAbsoluteFile()));
        args.add("-printseeds");
        args.add(ProGuardMojo.fileToString(new File(this.outputDirectory, this.seedFileName).getAbsoluteFile()));
        if (this.log.isDebugEnabled()) {
            args.add("-verbose");
        }
        if (this.options != null) {
            for (int i = 0; i < this.options.length; ++i) {
                args.add(this.options[i]);
            }
        }
        this.log.info((CharSequence)("execute ProGuard " + args.toString()));
        ProGuardMojo.proguardMain(ProGuardMojo.getProguardJar(this), args, this);
        if (this.assembly != null && hasInclusionLibrary) {
            this.log.info((CharSequence)"creating assembly");
            File baseFile = new File(this.outputDirectory, ProGuardMojo.nameNoType(this.injar) + "_proguard_result.jar");
            if (baseFile.exists() && !baseFile.delete()) {
                throw new MojoFailureException("Can't delete " + baseFile);
            }
            File archiverFile = outJarFile.getAbsoluteFile();
            if (!outJarFile.renameTo(baseFile)) {
                throw new MojoFailureException("Can't rename " + outJarFile);
            }
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            archiver.setOutputFile(archiverFile);
            this.archive.setAddMavenDescriptor(this.addMavenDescriptor);
            try {
                this.jarArchiver.addArchivedFileSet(baseFile);
                for (Inclusion inc : this.assembly.inclusions) {
                    if (!inc.library) continue;
                    Artifact artifact = ProGuardMojo.getDependancy(inc, this.mavenProject);
                    File file = ProGuardMojo.getClasspathElement(artifact, this.mavenProject);
                    if (file.isDirectory()) {
                        this.getLog().info((CharSequence)("merge project: " + artifact.getArtifactId() + " " + file));
                        this.jarArchiver.addDirectory(file);
                        continue;
                    }
                    this.getLog().info((CharSequence)("merge artifact: " + artifact.getArtifactId()));
                    this.jarArchiver.addArchivedFileSet(file);
                }
                archiver.createArchive(this.mavenProject, this.archive);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to create jar", e);
            }
        }
        if (this.attach && !sameArtifact) {
            if (this.useArtifactClassifier()) {
                this.projectHelper.attachArtifact(this.mavenProject, this.attachArtifactType, this.attachArtifactClassifier, outJarFile);
            } else {
                this.projectHelper.attachArtifact(this.mavenProject, this.attachArtifactType, null, outJarFile);
            }
        }
    }

    private static File getProguardJar(ProGuardMojo mojo) throws MojoExecutionException {
        Artifact proguardArtifact = null;
        int proguardArtifactDistance = -1;
        for (Artifact artifact : mojo.pluginArtifacts) {
            mojo.getLog().debug((CharSequence)("pluginArtifact: " + artifact.getFile()));
            if (!artifact.getArtifactId().startsWith("proguard") || artifact.getArtifactId().startsWith("proguard-maven-plugin")) continue;
            int distance = artifact.getDependencyTrail().size();
            mojo.getLog().debug((CharSequence)("proguard DependencyTrail: " + distance));
            if (mojo.proguardVersion != null && mojo.proguardVersion.equals(artifact.getVersion())) {
                proguardArtifact = artifact;
                break;
            }
            if (proguardArtifactDistance == -1) {
                proguardArtifact = artifact;
                proguardArtifactDistance = distance;
                continue;
            }
            if (distance >= proguardArtifactDistance) continue;
            proguardArtifact = artifact;
            proguardArtifactDistance = distance;
        }
        if (proguardArtifact != null) {
            mojo.getLog().debug((CharSequence)("proguardArtifact: " + proguardArtifact.getFile()));
            return proguardArtifact.getFile().getAbsoluteFile();
        }
        mojo.getLog().info((CharSequence)"proguard jar not found in pluginArtifacts");
        ClassLoader cl = ((Object)((Object)mojo)).getClass().getClassLoader();
        String string = "/" + mojo.proguardMainClass.replace('.', '/') + ".class";
        URL url = cl.getResource(string);
        if (url == null) {
            throw new MojoExecutionException("Obfuscation failed ProGuard (" + mojo.proguardMainClass + ") not found in classpath");
        }
        String proguardJar = url.toExternalForm();
        if (!proguardJar.startsWith("jar:file:")) {
            throw new MojoExecutionException("Unrecognized location (" + proguardJar + ") in classpath");
        }
        proguardJar = proguardJar.substring("jar:file:".length());
        proguardJar = proguardJar.substring(0, proguardJar.indexOf(33));
        return new File(proguardJar);
    }

    private static void proguardMain(File proguardJar, ArrayList argsList, ProGuardMojo mojo) throws MojoExecutionException {
        Java java = new Java();
        Project antProject = new Project();
        antProject.setName(mojo.mavenProject.getName());
        antProject.init();
        DefaultLogger antLogger = new DefaultLogger();
        antLogger.setOutputPrintStream(System.out);
        antLogger.setErrorPrintStream(System.err);
        antLogger.setMessageOutputLevel(mojo.log.isDebugEnabled() ? 4 : 2);
        antProject.addBuildListener((BuildListener)antLogger);
        antProject.setBaseDir(mojo.mavenProject.getBasedir());
        java.setProject(antProject);
        java.setTaskName("proguard");
        mojo.getLog().info((CharSequence)("proguard jar: " + proguardJar));
        java.createClasspath().setLocation(proguardJar);
        java.setClassname(mojo.proguardMainClass);
        java.setFailonerror(true);
        java.setFork(true);
        if (mojo.maxMemory != null) {
            java.setMaxmemory(mojo.maxMemory);
        }
        Iterator i = argsList.iterator();
        while (i.hasNext()) {
            java.createArg().setValue(i.next().toString());
        }
        int result = java.executeJava();
        if (result != 0) {
            throw new MojoExecutionException("Obfuscation failed (result=" + result + ")");
        }
    }

    private static String nameNoType(String fileName) {
        int extStart = fileName.lastIndexOf(46);
        if (extStart == -1) {
            return fileName;
        }
        return fileName.substring(0, extStart);
    }

    private static boolean deleteFileOrDirectory(File path) throws MojoFailureException {
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    if (ProGuardMojo.deleteFileOrDirectory(files[i])) continue;
                    throw new MojoFailureException("Can't delete dir " + files[i]);
                }
                if (files[i].delete()) continue;
                throw new MojoFailureException("Can't delete file " + files[i]);
            }
            return path.delete();
        }
        return path.delete();
    }

    private static Artifact getDependancy(Inclusion inc, MavenProject mavenProject) throws MojoExecutionException {
        Set dependancy = mavenProject.getArtifacts();
        for (Artifact artifact : dependancy) {
            if (!inc.match(artifact)) continue;
            return artifact;
        }
        throw new MojoExecutionException("artifactId Not found " + inc.artifactId);
    }

    private boolean isExclusion(Artifact artifact) {
        if (this.exclusions == null) {
            return false;
        }
        for (Exclusion exclusion : this.exclusions) {
            if (!exclusion.match(artifact)) continue;
            return true;
        }
        return false;
    }

    private static File getClasspathElement(Artifact artifact, MavenProject mavenProject) throws MojoExecutionException {
        if (artifact.getClassifier() != null) {
            return artifact.getFile();
        }
        String refId = artifact.getGroupId() + ":" + artifact.getArtifactId();
        MavenProject project = (MavenProject)mavenProject.getProjectReferences().get(refId);
        if (project != null) {
            return new File(project.getBuild().getOutputDirectory());
        }
        File file = artifact.getFile();
        if (file == null || !file.exists()) {
            throw new MojoExecutionException("Dependency Resolution Required " + artifact);
        }
        return file;
    }
}

