/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.reflect;

import com.github.mustachejava.Binding;
import com.github.mustachejava.Code;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.PartialCode;
import com.github.mustachejava.reflect.MissingWrapper;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;

public class GuardedBinding
implements Binding {
    private static Logger logger = Logger.getLogger("mustache");
    private static boolean debug = Boolean.getBoolean("mustache.debug");
    private final ObjectHandler oh;
    private final TemplateContext tc;
    private final String name;
    private final Code code;
    private Set<Wrapper> previousSet = new CopyOnWriteArraySet<Wrapper>();
    private volatile Wrapper[] prevWrappers;

    public GuardedBinding(ObjectHandler oh, String name, TemplateContext tc, Code code) {
        this.name = name;
        this.code = code;
        this.oh = oh;
        this.tc = tc;
    }

    @Override
    public Object get(Object[] scopes) {
        Wrapper current = null;
        Wrapper[] wrappers = this.prevWrappers;
        if (wrappers != null) {
            for (Wrapper prevWrapper : wrappers) {
                try {
                    current = prevWrapper;
                    return this.oh.coerce(prevWrapper.call(scopes));
                }
                catch (GuardException ge) {
                }
                catch (MustacheException me) {
                    throw new MustacheException("Failed: " + current, me);
                }
            }
        }
        return this.createAndGet(scopes);
    }

    private Object createAndGet(Object[] scopes) {
        Wrapper wrapper = this.getWrapper(this.name, scopes);
        this.previousSet.add(wrapper);
        if (this.prevWrappers == null || this.prevWrappers.length != this.previousSet.size()) {
            this.prevWrappers = this.previousSet.toArray(new Wrapper[this.previousSet.size()]);
        }
        try {
            return this.oh.coerce(wrapper.call(scopes));
        }
        catch (GuardException e) {
            throw new AssertionError((Object)("Unexpected guard failure: " + this.previousSet + " " + Arrays.asList(scopes)));
        }
    }

    protected synchronized Wrapper getWrapper(String name, Object[] scopes) {
        Wrapper wrapper = this.oh.find(name, scopes);
        if (wrapper instanceof MissingWrapper && debug && !(this.code instanceof PartialCode)) {
            StringBuilder sb = new StringBuilder("Failed to find: ").append(name).append(" (").append(this.tc.file()).append(":").append(this.tc.line()).append(") ").append("in");
            for (Object scope : scopes) {
                if (scope == null) continue;
                sb.append(" ").append(scope.getClass().getSimpleName());
            }
            logger.warning(sb.toString());
        }
        return wrapper;
    }
}

