/*
 * Decompiled with CFR 0.152.
 */
package com.github.slavaz.maven.plugin.postgresql.embedded.goals;

import com.github.slavaz.maven.plugin.postgresql.embedded.classloader.ClassLoaderHolder;
import com.github.slavaz.maven.plugin.postgresql.embedded.classloader.ClassLoaderUtils;
import com.github.slavaz.maven.plugin.postgresql.embedded.goals.AbstractGoalMojo;
import com.github.slavaz.maven.plugin.postgresql.embedded.psql.IPgInstanceProcessData;
import com.github.slavaz.maven.plugin.postgresql.embedded.psql.IsolatedPgInstanceManager;
import com.github.slavaz.maven.plugin.postgresql.embedded.psql.data.PgInstanceProcessData;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="start")
public class StartGoalMojo
extends AbstractGoalMojo {
    @Parameter(defaultValue="${project.build.directory}")
    private String projectBuildDir;
    @Parameter(defaultValue="latest", property="pgVersion", required=true)
    private String pgServerVersion;
    @Parameter(property="pgDatabasedir")
    private String pgDatabaseDir;
    @Parameter(property="dbname", required=true)
    private String dbName;
    @Parameter(defaultValue="postgres", property="username", required=true)
    private String userName;
    @Parameter(defaultValue="postgres", required=true)
    private String password;
    @Parameter(property="pgLocale")
    private String pgLocale;
    @Parameter(property="pgCharset")
    private String pgCharset;
    @Parameter(property="pgHost", defaultValue="localhost")
    private String pgHost;
    @Parameter(defaultValue="5432", property="pgPort", required=true)
    private int pgServerPort;
    @Parameter(readonly=true, defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginDependencies;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)"Starting PostgreSQL...");
            this.calculateDatabaseDir();
            ClassLoader classLoader = ClassLoaderUtils.buildClassLoader(this.pluginDependencies);
            ClassLoaderHolder.setClassLoader(classLoader);
            new IsolatedPgInstanceManager(classLoader).start(this.buildInstanceProcessData());
            this.getLog().debug((CharSequence)"PostgreSQL started.");
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Failed to start PostgreSQL", (Throwable)e);
        }
    }

    private void calculateDatabaseDir() {
        if (StringUtils.isEmpty((CharSequence)this.pgDatabaseDir)) {
            this.pgDatabaseDir = this.projectBuildDir + File.separator + "pgdata";
        }
    }

    private IPgInstanceProcessData buildInstanceProcessData() {
        return new PgInstanceProcessData(this.pgServerVersion, this.pgHost, this.pgServerPort, this.dbName, this.userName, this.password, this.pgDatabaseDir, this.pgLocale, this.pgCharset);
    }
}

