/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import com.github.kongchen.swagger.docgen.LogAdapter;
import com.github.kongchen.swagger.docgen.jaxrs.BeanParamInjectParamExtention;
import com.github.kongchen.swagger.docgen.jaxrs.JaxrsParameterExtension;
import com.github.kongchen.swagger.docgen.reader.SpringMvcApiReader;
import com.github.kongchen.swagger.docgen.spring.SpringSwaggerExtension;
import com.sun.jersey.api.core.InjectParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import io.swagger.annotations.ResponseHeader;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.jersey.SwaggerJerseyJaxrs;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.ParameterProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.BeanParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class AbstractReader {
    protected final LogAdapter LOG;
    protected Swagger swagger;
    protected Set<Type> typesToSkip = new HashSet<Type>();

    public Set<Type> getTypesToSkip() {
        return this.typesToSkip;
    }

    public void setTypesToSkip(List<Type> typesToSkip) {
        this.typesToSkip = new HashSet<Type>(typesToSkip);
    }

    public void setTypesToSkip(Set<Type> typesToSkip) {
        this.typesToSkip = typesToSkip;
    }

    public void addTypeToSkippedTypes(Type type) {
        this.typesToSkip.add(type);
    }

    public AbstractReader(Swagger swagger, LogAdapter LOG) {
        this.swagger = swagger;
        this.LOG = LOG;
        this.updateExtensionChain();
    }

    private void updateExtensionChain() {
        ArrayList<Object> extensions = new ArrayList<Object>();
        if (this.getClass() == SpringMvcApiReader.class) {
            extensions.add((Object)new SpringSwaggerExtension());
        } else {
            extensions.add((Object)new BeanParamInjectParamExtention());
            extensions.add(new SwaggerJerseyJaxrs());
            extensions.add((Object)new JaxrsParameterExtension());
        }
        SwaggerExtensions.setExtensions(extensions);
    }

    protected List<SecurityRequirement> getSecurityRequirements(Api api) {
        int position = api.position();
        String produces = api.produces();
        String consumes = api.consumes();
        String schems = api.protocols();
        Authorization[] authorizations = api.authorizations();
        ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
        for (Authorization auth : authorizations) {
            AuthorizationScope[] scopes;
            if (auth.value() == null || "".equals(auth.value())) continue;
            SecurityRequirement security = new SecurityRequirement();
            security.setName(auth.value());
            for (AuthorizationScope scope : scopes = auth.scopes()) {
                if (scope.scope() == null || "".equals(scope.scope())) continue;
                security.addScope(scope.scope());
            }
            securities.add(security);
        }
        return securities;
    }

    protected String parseOperationPath(String operationPath, Map<String, String> regexMap) {
        if (operationPath.equalsIgnoreCase("/")) {
            return operationPath;
        }
        String[] pps = operationPath.split("/");
        String[] pathParts = new String[pps.length];
        for (int i = 0; i < pps.length; ++i) {
            String p = pps[i];
            if (p.startsWith("{")) {
                int pos = p.indexOf(":");
                if (pos > 0) {
                    String left = p.substring(1, pos);
                    String right = p.substring(pos + 1, p.length() - 1);
                    pathParts[i] = "{" + left.trim() + "}";
                    regexMap.put(left.trim(), right);
                    continue;
                }
                pathParts[i] = p;
                continue;
            }
            pathParts[i] = p;
        }
        StringBuilder pathBuilder = new StringBuilder();
        for (String p : pathParts) {
            if (p.isEmpty()) continue;
            pathBuilder.append("/").append(p);
        }
        operationPath = pathBuilder.toString();
        return operationPath;
    }

    protected void updateOperationParameters(List<Parameter> parentParameters, Map<String, String> regexMap, Operation operation) {
        if (parentParameters != null) {
            for (Parameter param : parentParameters) {
                operation.parameter(param);
            }
        }
        for (Parameter param : operation.getParameters()) {
            if (regexMap.get(param.getName()) == null) continue;
            String pattern = regexMap.get(param.getName());
            param.setPattern(pattern);
        }
    }

    protected Map<String, Property> parseResponseHeaders(ResponseHeader[] headers) {
        HashMap<String, ArrayProperty> responseHeaders = null;
        if (headers != null && headers.length > 0) {
            for (ResponseHeader header : headers) {
                String name = header.name();
                if ("".equals(name)) continue;
                if (responseHeaders == null) {
                    responseHeaders = new HashMap<String, ArrayProperty>();
                }
                String description = header.description();
                Class cls = header.response();
                String container = header.responseContainer();
                if (cls.equals(Void.class) || "void".equals(cls.toString())) continue;
                Object responseProperty = null;
                Property property = ModelConverters.getInstance().readAsProperty((Type)cls);
                if (property == null) continue;
                responseProperty = "list".equalsIgnoreCase(container) ? new ArrayProperty(property) : ("map".equalsIgnoreCase(container) ? new MapProperty(property) : property);
                responseProperty.setDescription(description);
                responseHeaders.put(name, (ArrayProperty)responseProperty);
            }
        }
        return responseHeaders;
    }

    protected Set<Map<String, Object>> parseCustomExtensions(Extension[] extensions) {
        HashSet<Map<String, Object>> resultSet = new HashSet<Map<String, Object>>();
        if (extensions != null && extensions.length > 0) {
            for (Extension extension : extensions) {
                if (extension == null || extension.properties().length <= 0) continue;
                HashMap<String, String> extensionProperties = null;
                for (ExtensionProperty extensionProperty : extension.properties()) {
                    String name = extensionProperty.name();
                    if ("".equals(name)) continue;
                    if (extensionProperties == null) {
                        extensionProperties = new HashMap<String, String>();
                    }
                    String value = extensionProperty.value();
                    extensionProperties.put(name, value);
                }
                if (extension.name() != null && extension.name().length() > 0) {
                    HashMap wrapper = new HashMap();
                    wrapper.put(extension.name(), extensionProperties);
                    resultSet.add(wrapper);
                    continue;
                }
                resultSet.add(extensionProperties);
            }
        }
        return resultSet;
    }

    protected void updatePath(String operationPath, String httpMethod, Operation operation) {
        if (httpMethod == null) {
            return;
        }
        Path path = this.swagger.getPath(operationPath);
        if (path == null) {
            path = new Path();
            this.swagger.path(operationPath, path);
        }
        path.set(httpMethod, operation);
    }

    protected void updateTagsForOperation(Operation operation, ApiOperation op) {
        if (op != null) {
            boolean hasExplicitTag = false;
            for (String tag : op.tags()) {
                if ("".equals(tag)) continue;
                operation.tag(tag);
                this.swagger.tag(new Tag().name(tag));
            }
        }
    }

    protected boolean canReadApi(boolean readHidden, Api api) {
        return api != null && readHidden || api != null && !api.hidden();
    }

    protected Set<Tag> extractTags(Api api) {
        String tagString;
        LinkedHashSet<Tag> output = new LinkedHashSet<Tag>();
        boolean hasExplicitTags = false;
        for (String tag : api.tags()) {
            if ("".equals(tag)) continue;
            hasExplicitTags = true;
            output.add(new Tag().name(tag));
        }
        if (!hasExplicitTags && !"".equals(tagString = api.value().replace("/", ""))) {
            Tag tag = new Tag().name(tagString);
            if (!"".equals(api.description())) {
                tag.description(api.description());
            }
            output.add(tag);
        }
        return output;
    }

    protected void updateOperationProtocols(ApiOperation apiOperation, Operation operation) {
        String protocols = apiOperation.protocols();
        if (!"".equals(protocols)) {
            String[] parts;
            for (String part : parts = protocols.split(",")) {
                String trimmed = part.trim();
                if ("".equals(trimmed)) continue;
                operation.scheme(Scheme.forValue((String)trimmed));
            }
        }
    }

    protected Map<String, Tag> updateTagsForApi(Map<String, Tag> parentTags, Api api) {
        Set<Tag> tags = this.extractTags(api);
        HashMap<String, Tag> tagsMap = new HashMap<String, Tag>();
        for (Tag tag : tags) {
            tagsMap.put(tag.getName(), tag);
        }
        if (parentTags != null) {
            tagsMap.putAll(parentTags);
        }
        for (Tag tag : tagsMap.values()) {
            this.swagger.tag(tag);
        }
        return tagsMap;
    }

    boolean isPrimitive(Class<?> cls) {
        boolean out = false;
        Property property = ModelConverters.getInstance().readAsProperty(cls);
        if (property == null) {
            out = false;
        } else if ("integer".equals(property.getType())) {
            out = true;
        } else if ("string".equals(property.getType())) {
            out = true;
        } else if ("number".equals(property.getType())) {
            out = true;
        } else if ("boolean".equals(property.getType())) {
            out = true;
        } else if ("array".equals(property.getType())) {
            out = true;
        } else if ("file".equals(property.getType())) {
            out = true;
        }
        return out;
    }

    protected void updateOperation(String[] apiConsumes, String[] apiProduces, Map<String, Tag> tags, List<SecurityRequirement> securities, Operation operation) {
        if (operation == null) {
            return;
        }
        if (operation.getConsumes() == null) {
            for (String string : apiConsumes) {
                operation.consumes(string);
            }
        }
        if (operation.getProduces() == null) {
            for (String string : apiProduces) {
                operation.produces(string);
            }
        }
        if (operation.getTags() == null) {
            for (String tagString : tags.keySet()) {
                operation.tag(tagString);
            }
        }
        for (SecurityRequirement security : securities) {
            operation.security(security);
        }
    }

    private boolean isApiParamHidden(List<Annotation> parameterAnnotations) {
        boolean isHidden = false;
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (!(parameterAnnotation instanceof ApiParam)) continue;
            isHidden = ((ApiParam)parameterAnnotation).hidden();
            break;
        }
        return isHidden;
    }

    private boolean hasValidAnnotations(List<Annotation> parameterAnnotations) {
        if (parameterAnnotations.isEmpty()) {
            return false;
        }
        ArrayList<Class> validParameterAnnotations = new ArrayList<Class>();
        validParameterAnnotations.add(ModelAttribute.class);
        validParameterAnnotations.add(BeanParam.class);
        validParameterAnnotations.add(InjectParam.class);
        validParameterAnnotations.add(ApiParam.class);
        validParameterAnnotations.add(PathParam.class);
        validParameterAnnotations.add(QueryParam.class);
        validParameterAnnotations.add(HeaderParam.class);
        validParameterAnnotations.add(FormParam.class);
        validParameterAnnotations.add(RequestParam.class);
        validParameterAnnotations.add(RequestBody.class);
        validParameterAnnotations.add(PathVariable.class);
        validParameterAnnotations.add(RequestHeader.class);
        boolean hasValidAnnotation = false;
        for (Annotation potentialAnnotation : parameterAnnotations) {
            if (!validParameterAnnotations.contains(potentialAnnotation.annotationType())) continue;
            hasValidAnnotation = true;
            break;
        }
        return hasValidAnnotation;
    }

    protected List<Parameter> getParameters(Type type, List<Annotation> annotations) {
        if (!this.hasValidAnnotations(annotations)) {
            return new ArrayList<Parameter>();
        }
        if (this.isApiParamHidden(annotations)) {
            return new ArrayList<Parameter>();
        }
        Iterator chain = SwaggerExtensions.chain();
        List<Object> parameters = new ArrayList<Parameter>();
        Class cls = TypeUtils.getRawType((Type)type, (Type)type);
        this.LOG.info("Looking for path/query/header/form/cookie params in " + cls);
        if (chain.hasNext()) {
            SwaggerExtension extension = (SwaggerExtension)chain.next();
            this.LOG.info("trying extension " + extension);
            parameters = extension.extractParameters(annotations, type, this.typesToSkip, chain);
        }
        if (parameters.size() > 0) {
            for (Parameter parameter : parameters) {
                ParameterProcessor.applyAnnotations((Swagger)this.swagger, (Parameter)parameter, (Type)type, annotations);
                Parameter parameter2 = this.fixCollectionFormatForArrayTypes(cls, parameter);
            }
        } else {
            Parameter param;
            this.LOG.info("Looking for body params in " + cls);
            if (!this.typesToSkip.contains(type) && (param = ParameterProcessor.applyAnnotations((Swagger)this.swagger, null, (Type)type, annotations)) != null) {
                parameters.add(param);
            }
        }
        return parameters;
    }

    private Parameter fixCollectionFormatForArrayTypes(Class<?> cls, Parameter parameter) {
        AbstractSerializableParameter p;
        if (parameter instanceof AbstractSerializableParameter && (p = (AbstractSerializableParameter)parameter).getItems() != null && p.getCollectionFormat() == "csv" && (Collection.class.isAssignableFrom(cls) || cls.isArray())) {
            p.collectionFormat("multi");
            parameter = p;
        }
        return parameter;
    }

    protected void updateApiResponse(Operation operation, ApiResponses responseAnnotation) {
        for (ApiResponse apiResponse : responseAnnotation.value()) {
            Response apiOperationResponse;
            Map<String, Property> responseHeaders = this.parseResponseHeaders(apiResponse.responseHeaders());
            Class responseClass = apiResponse.response();
            Response response = new Response().description(apiResponse.message()).headers(responseHeaders);
            if ((responseClass == null || responseClass.equals(Void.class)) && operation.getResponses() != null && !operation.getResponses().isEmpty() && (apiOperationResponse = (Response)operation.getResponses().get(String.valueOf(apiResponse.code()))) != null) {
                response.setSchema(apiOperationResponse.getSchema());
            }
            if (apiResponse.code() == 0) {
                operation.defaultResponse(response);
            } else {
                operation.response(apiResponse.code(), response);
            }
            if (responseClass == null || responseClass.equals(Void.class)) continue;
            Map models = ModelConverters.getInstance().read((Type)responseClass);
            for (String key : models.keySet()) {
                response.schema((Property)new RefProperty().asDefault(key));
                this.swagger.model(key, (Model)models.get(key));
            }
            models = ModelConverters.getInstance().readAll((Type)responseClass);
            for (String key : models.keySet()) {
                this.swagger.model(key, (Model)models.get(key));
            }
        }
    }

    protected String[] updateOperationProduces(String[] parentProduces, String[] apiProduces, Operation operation) {
        if (parentProduces != null) {
            HashSet<String> both = new HashSet<String>(Arrays.asList(apiProduces));
            both.addAll(new HashSet<String>(Arrays.asList(parentProduces)));
            if (operation.getProduces() != null) {
                both.addAll(new HashSet(operation.getProduces()));
            }
            apiProduces = both.toArray(new String[both.size()]);
        }
        return apiProduces;
    }

    protected String[] updateOperationConsumes(String[] parentConsumes, String[] apiConsumes, Operation operation) {
        if (parentConsumes != null) {
            HashSet<String> both = new HashSet<String>(Arrays.asList(apiConsumes));
            both.addAll(new HashSet<String>(Arrays.asList(parentConsumes)));
            if (operation.getConsumes() != null) {
                both.addAll(new HashSet(operation.getConsumes()));
            }
            apiConsumes = both.toArray(new String[both.size()]);
        }
        return apiConsumes;
    }

    protected void readImplicitParameters(Method method, Operation operation) {
        ApiImplicitParams implicitParams = method.getAnnotation(ApiImplicitParams.class);
        if (implicitParams != null && implicitParams.value().length > 0) {
            for (ApiImplicitParam param : implicitParams.value()) {
                Class<?> cls = null;
                try {
                    cls = Class.forName(param.dataType());
                }
                catch (ClassNotFoundException e) {
                    cls = method.getDeclaringClass();
                }
                Parameter p = this.readImplicitParam(param, cls);
                if (p == null) continue;
                operation.addParameter(p);
            }
        }
    }

    protected Parameter readImplicitParam(ApiImplicitParam param, Class<?> apiClass) {
        PathParameter p;
        if (param.paramType().equalsIgnoreCase("path")) {
            p = new PathParameter();
        } else if (param.paramType().equalsIgnoreCase("query")) {
            p = new QueryParameter();
        } else if (param.paramType().equalsIgnoreCase("form") || param.paramType().equalsIgnoreCase("formData")) {
            p = new FormParameter();
        } else if (param.paramType().equalsIgnoreCase("body")) {
            p = new BodyParameter();
        } else if (param.paramType().equalsIgnoreCase("header")) {
            p = new HeaderParameter();
        } else {
            return null;
        }
        return ParameterProcessor.applyAnnotations((Swagger)this.swagger, (Parameter)p, apiClass, Arrays.asList(param));
    }
}

