/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

import smile.validation.metric.RegressionMetric;

public class RSS
implements RegressionMetric {
    private static final long serialVersionUID = 2L;
    public static final RSS instance = new RSS();

    @Override
    public double score(double[] truth, double[] prediction) {
        return RSS.of(truth, prediction);
    }

    public static double of(double[] truth, double[] prediction) {
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        int n = truth.length;
        double rss = 0.0;
        for (int i = 0; i < n; ++i) {
            double r = truth[i] - prediction[i];
            rss += r * r;
        }
        return rss;
    }

    public String toString() {
        return "RSS";
    }
}

