/*
 * Decompiled with CFR 0.152.
 */
package smile.hpo;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import smile.math.MathEx;

public class Hyperparameters {
    private final HashMap<String, Object> parameters = new HashMap();

    public Hyperparameters add(String name, int value) {
        return this.add(name, new int[]{value});
    }

    public Hyperparameters add(String name, double value) {
        return this.add(name, new double[]{value});
    }

    public Hyperparameters add(String name, String value) {
        return this.add(name, new String[]{value});
    }

    public Hyperparameters add(String name, int[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        this.parameters.put(name, values);
        return this;
    }

    public Hyperparameters add(String name, double[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        this.parameters.put(name, values);
        return this;
    }

    public Hyperparameters add(String name, String[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        this.parameters.put(name, values);
        return this;
    }

    public Hyperparameters add(String name, int start, int end) {
        this.parameters.put(name, new IntRange(start, end));
        return this;
    }

    public Hyperparameters add(String name, int start, int end, int step) {
        this.parameters.put(name, new IntRange(start, end, step));
        return this;
    }

    public Hyperparameters add(String name, double start, double end) {
        this.parameters.put(name, new DoubleRange(start, end));
        return this;
    }

    public Hyperparameters add(String name, double start, double end, double step) {
        this.parameters.put(name, new DoubleRange(start, end, step));
        return this;
    }

    public Stream<Properties> random() {
        return Stream.generate(() -> {
            Properties params = new Properties();
            this.parameters.forEach((name, values) -> {
                Object selector0$temp = values;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{int[].class, double[].class, String[].class, IntRange.class, DoubleRange.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        int[] a = (int[])selector0$temp;
                        int v = a.length == 1 ? a[0] : a[MathEx.randomInt((int)a.length)];
                        params.setProperty((String)name, String.valueOf(v));
                        break;
                    }
                    case 1: {
                        double[] a = (double[])selector0$temp;
                        double v = a.length == 1 ? a[0] : a[MathEx.randomInt((int)a.length)];
                        params.setProperty((String)name, String.valueOf(v));
                        break;
                    }
                    case 2: {
                        String[] a = (String[])selector0$temp;
                        String v = a.length == 1 ? a[0] : a[MathEx.randomInt((int)a.length)];
                        params.setProperty((String)name, v);
                        break;
                    }
                    case 3: {
                        IntRange range = (IntRange)selector0$temp;
                        params.setProperty((String)name, String.valueOf(MathEx.randomInt((int)range.start, (int)range.end)));
                        break;
                    }
                    case 4: {
                        DoubleRange range = (DoubleRange)selector0$temp;
                        params.setProperty((String)name, String.valueOf(MathEx.random((double)range.start, (double)range.end)));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown parameter type: " + String.valueOf(values));
                    }
                }
            });
            return params;
        });
    }

    public Stream<Properties> grid() {
        ArrayList<Map.Entry<String, Object>> lists = new ArrayList<Map.Entry<String, Object>>(this.parameters.entrySet());
        ArrayList combinations = new ArrayList();
        for (KeyValue pair : this.values(lists.getFirst())) {
            ArrayList<KeyValue> newList = new ArrayList<KeyValue>();
            newList.add(pair);
            combinations.add(newList);
        }
        for (int i = 1; i < lists.size(); ++i) {
            ArrayList<KeyValue> nextList = this.values(lists.get(i));
            ArrayList newCombinations = new ArrayList();
            for (ArrayList arrayList : combinations) {
                for (KeyValue second : nextList) {
                    ArrayList<KeyValue> newList = new ArrayList<KeyValue>(arrayList);
                    newList.add(second);
                    newCombinations.add(newList);
                }
            }
            combinations = newCombinations;
        }
        return combinations.stream().map(list -> {
            Properties params = new Properties();
            list.forEach(p -> params.setProperty(p.key(), p.value()));
            return params;
        });
    }

    private ArrayList<KeyValue> values(Map.Entry<String, Object> parameter) {
        Object values;
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        String name = parameter.getKey();
        Object object = values = parameter.getValue();
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{int[].class, double[].class, String[].class, IntRange.class, DoubleRange.class}, (Object)object, n)) {
            case 0: {
                int[] array;
                for (int value : array = (int[])object) {
                    list.add(new KeyValue(name, String.valueOf(value)));
                }
                break;
            }
            case 1: {
                double[] array;
                for (double value : array = (double[])object) {
                    list.add(new KeyValue(name, String.valueOf(value)));
                }
                break;
            }
            case 2: {
                String[] array;
                for (String value : array = (String[])object) {
                    list.add(new KeyValue(name, String.valueOf(value)));
                }
                break;
            }
            case 3: {
                IntRange range = (IntRange)object;
                for (int value : range.toArray()) {
                    list.add(new KeyValue(name, String.valueOf(value)));
                }
                break;
            }
            case 4: {
                DoubleRange range = (DoubleRange)object;
                for (double value : range.toArray()) {
                    list.add(new KeyValue(name, String.valueOf(value)));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown parameter type: " + String.valueOf(values));
            }
        }
        return list;
    }

    record IntRange(int start, int end, int step) {
        public IntRange {
            if (start >= end) {
                throw new IllegalArgumentException(String.format("start = %d, end = %d", start, end));
            }
            if (step <= 0) {
                throw new IllegalArgumentException("step = " + step);
            }
        }

        public IntRange(int start, int end) {
            this(start, end, Math.max(1, (end - start) / 10));
        }

        int[] toArray() {
            int n = (this.end - this.start) / this.step + 1;
            int[] a = new int[n];
            a[0] = this.start;
            for (int i = 1; i < n; ++i) {
                a[i] = a[i - 1] + this.step;
            }
            return a;
        }
    }

    record DoubleRange(double start, double end, double step) {
        public DoubleRange {
            if (start >= end) {
                throw new IllegalArgumentException(String.format("start = %f, end = %f", start, end));
            }
            if (step <= 0.0) {
                throw new IllegalArgumentException("step = " + step);
            }
        }

        public DoubleRange(double start, double end) {
            this(start, end, (end - start) / 10.0);
        }

        double[] toArray() {
            double intervals = (this.end - this.start) / this.step;
            int n = (int)Math.ceil(intervals);
            if (intervals == (double)n) {
                ++n;
            }
            double[] a = new double[n];
            a[0] = this.start;
            for (int i = 1; i < n; ++i) {
                a[i] = a[i - 1] + this.step;
            }
            return a;
        }
    }

    record KeyValue(String key, String value) {
    }
}

