/*
 * Decompiled with CFR 0.152.
 */
package smile.vq;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import smile.clustering.CentroidClustering;
import smile.manifold.MDS;
import smile.math.MathEx;
import smile.math.TimeFunction;
import smile.sort.QuickSort;
import smile.vq.Neighborhood;
import smile.vq.VectorQuantizer;

public class SOM
implements VectorQuantizer {
    private static final long serialVersionUID = 2L;
    private final int nrow;
    private final int ncol;
    private final Neuron[][] map;
    private final Neuron[] neurons;
    private final double[] dist;
    private final TimeFunction alpha;
    private final Neighborhood theta;
    private final double tol = 1.0E-5;
    private int t = 0;

    public SOM(double[][][] neurons, TimeFunction alpha, Neighborhood theta) {
        this.alpha = alpha;
        this.theta = theta;
        this.nrow = neurons.length;
        this.ncol = neurons[0].length;
        this.map = new Neuron[this.nrow][this.ncol];
        this.neurons = new Neuron[this.nrow * this.ncol];
        this.dist = new double[this.neurons.length];
        int k = 0;
        for (int i = 0; i < this.nrow; ++i) {
            int j = 0;
            while (j < this.ncol) {
                Neuron neuron;
                this.map[i][j] = neuron = new Neuron(i, j, (double[])neurons[i][j].clone());
                this.neurons[k] = neuron;
                ++j;
                ++k;
            }
        }
    }

    public static double[][][] lattice(int nrow, int ncol, double[][] samples) {
        int k = nrow * ncol;
        int n = samples.length;
        int[] clusters = new int[n];
        double[][] medoids = new double[k][];
        CentroidClustering.seed(samples, medoids, clusters, MathEx::squaredDistance);
        double[][] pdist = new double[k][k];
        MathEx.pdist((Object[])medoids, (double[][])pdist, MathEx::distance);
        MDS mds = MDS.of(pdist);
        double[][] coordinates = mds.coordinates;
        double[] x = Arrays.stream(coordinates).mapToDouble(point -> point[0]).toArray();
        double[] y = new double[ncol];
        int[] row = new int[ncol];
        int[] index = QuickSort.sort((double[])x);
        double[][][] neurons = new double[nrow][ncol][];
        for (int i = 0; i < nrow; ++i) {
            int j;
            for (j = 0; j < ncol; ++j) {
                int point2 = index[i * ncol + j];
                y[j] = coordinates[point2][1];
                row[j] = point2;
            }
            QuickSort.sort((double[])y, (int[])row);
            for (j = 0; j < ncol; ++j) {
                neurons[i][j] = medoids[row[j]];
            }
        }
        return neurons;
    }

    @Override
    public void update(double[] x) {
        Neuron bmu = this.bmu(x);
        int i = bmu.i;
        int j = bmu.j;
        int d = bmu.w.length;
        double alpha = this.alpha.apply(this.t);
        ((Stream)Arrays.stream(this.neurons).parallel()).forEach(neuron -> {
            double delta = alpha * this.theta.of(neuron.i - i, neuron.j - j, this.t);
            if (delta > 1.0E-5) {
                double[] w = neuron.w;
                for (int k = 0; k < d; ++k) {
                    int n = k;
                    w[n] = w[n] + delta * (x[k] - w[k]);
                }
            }
        });
        ++this.t;
    }

    public double[][][] neurons() {
        double[][][] lattice = new double[this.nrow][this.ncol][];
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                lattice[i][j] = this.map[i][j].w;
            }
        }
        return lattice;
    }

    public double[][] umatrix() {
        int i;
        double[][] umatrix = new double[this.nrow][this.ncol];
        for (i = 0; i < this.nrow - 1; ++i) {
            for (int j = 0; j < this.ncol - 1; ++j) {
                double dist = Math.sqrt(MathEx.distance((double[])this.map[i][j].w, (double[])this.map[i][j + 1].w));
                umatrix[i][j] = Math.max(umatrix[i][j], dist);
                umatrix[i][j + 1] = Math.max(umatrix[i][j + 1], dist);
                dist = Math.sqrt(MathEx.distance((double[])this.map[i][j].w, (double[])this.map[i + 1][j].w));
                umatrix[i][j] = Math.max(umatrix[i][j], dist);
                umatrix[i + 1][j] = Math.max(umatrix[i + 1][j], dist);
            }
        }
        for (i = 0; i < this.nrow - 1; ++i) {
            double dist = Math.sqrt(MathEx.distance((double[])this.map[i][this.ncol - 1].w, (double[])this.map[i + 1][this.ncol - 1].w));
            umatrix[i][this.ncol - 1] = Math.max(umatrix[i][this.ncol - 1], dist);
            umatrix[i + 1][this.ncol - 1] = Math.max(umatrix[i + 1][this.ncol - 1], dist);
        }
        for (int j = 0; j < this.ncol - 1; ++j) {
            double dist = Math.sqrt(MathEx.distance((double[])this.map[this.nrow - 1][j].w, (double[])this.map[this.nrow - 1][j + 1].w));
            umatrix[this.nrow - 1][j] = Math.max(umatrix[this.nrow - 1][j], dist);
            umatrix[this.nrow - 1][j + 1] = Math.max(umatrix[this.nrow - 1][j + 1], dist);
        }
        umatrix[this.nrow - 1][this.ncol - 1] = Math.max(umatrix[this.nrow - 1][this.ncol - 2], umatrix[this.nrow - 2][this.ncol - 1]);
        return umatrix;
    }

    @Override
    public double[] quantize(double[] x) {
        return this.bmu((double[])x).w;
    }

    private Neuron bmu(double[] x) {
        IntStream.range(0, this.neurons.length).parallel().forEach(i -> {
            this.dist[i] = MathEx.distance((double[])this.neurons[i].w, (double[])x);
        });
        QuickSort.sort((double[])this.dist, (Object[])this.neurons);
        return this.neurons[0];
    }

    private static class Neuron
    implements Serializable {
        public final double[] w;
        public final int i;
        public final int j;

        public Neuron(int i, int j, double[] w) {
            this.i = i;
            this.j = j;
            this.w = w;
        }
    }
}

