/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.io.Serializable;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.graph.AdjacencyList;
import smile.manifold.NearestNeighborGraph;
import smile.math.MathEx;
import smile.math.blas.Transpose;
import smile.math.matrix.ARPACK;
import smile.math.matrix.IMatrix;
import smile.math.matrix.Matrix;
import smile.math.matrix.SparseMatrix;

public class LLE
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(LLE.class);
    public final int[] index;
    public final double[][] coordinates;
    public AdjacencyList graph;

    public LLE(int[] index, double[][] coordinates, AdjacencyList graph) {
        this.index = index;
        this.coordinates = coordinates;
        this.graph = graph;
    }

    public static LLE of(double[][] data, int k) {
        return LLE.of(data, k, 2);
    }

    public static LLE of(double[][] data, int k, int d) {
        int i;
        int D = data[0].length;
        double tol = 0.0;
        if (k > D) {
            logger.info("LLE: regularization will be used since K > D.");
            tol = 0.001;
        }
        int[][] N = new int[data.length][k];
        AdjacencyList graph = NearestNeighborGraph.of(data, k, false, (v1, v2, weight, j) -> {
            N[v1][j] = v2;
        });
        NearestNeighborGraph nng = NearestNeighborGraph.largest(graph);
        int[] index = nng.index;
        int n = data.length;
        graph = nng.graph;
        int[] reverseIndex = new int[n];
        if (index.length == n) {
            for (i = 0; i < n; ++i) {
                reverseIndex[i] = i;
            }
        } else {
            n = index.length;
            for (i = 0; i < index.length; ++i) {
                reverseIndex[index[i]] = i;
            }
        }
        int len = n * k;
        double[] w = new double[len];
        int[] rowIndex = new int[len];
        int[] colIndex = new int[n + 1];
        for (int i2 = 1; i2 <= n; ++i2) {
            colIndex[i2] = colIndex[i2 - 1] + k;
        }
        Matrix C = new Matrix(k, k);
        double[] b = new double[k];
        int m = 0;
        for (int i3 : index) {
            int p;
            double trace = 0.0;
            double[] xi = data[i3];
            for (p = 0; p < k; ++p) {
                double[] xip = data[N[i3][p]];
                for (int q = 0; q < k; ++q) {
                    double[] xiq = data[N[i3][q]];
                    C.set(p, q, 0.0);
                    for (int l = 0; l < D; ++l) {
                        C.add(p, q, (xi[l] - xip[l]) * (xi[l] - xiq[l]));
                    }
                }
                trace += C.get(p, p);
            }
            if (tol != 0.0) {
                trace *= tol;
                for (p = 0; p < k; ++p) {
                    C.add(p, p, trace);
                }
            }
            Arrays.fill(b, 1.0);
            Matrix.LU lu = C.lu(true);
            b = lu.solve(b);
            double sum = MathEx.sum((double[])b);
            int[] ni = N[i3];
            for (int p2 = 0; p2 < k; ++p2) {
                w[m * k + p2] = b[p2] / sum;
                rowIndex[m * k + p2] = reverseIndex[ni[p2]];
            }
            ++m;
        }
        SparseMatrix Wt = new SparseMatrix(n, n, w, rowIndex, colIndex);
        Matrix.EVD eigen = ARPACK.syev((IMatrix)new M(Wt), (ARPACK.SymmOption)ARPACK.SymmOption.SM, (int)Math.min(10 * (d + 1), n - 1));
        Matrix V = eigen.Vr;
        int offset = eigen.wr[eigen.wr.length - 1] < 1.0E-12 ? 2 : 1;
        double[][] coordinates = new double[n][d];
        int j2 = d;
        while (--j2 >= 0) {
            int c = V.ncol() - j2 - offset;
            for (int i4 = 0; i4 < n; ++i4) {
                coordinates[i4][j2] = V.get(i4, c);
            }
        }
        return new LLE(index, coordinates, graph);
    }

    private static class M
    extends IMatrix {
        SparseMatrix Wt;
        double[] x;
        double[] Wx;
        double[] Wtx;
        double[] WtWx;

        public M(SparseMatrix Wt) {
            this.Wt = Wt;
            this.x = new double[Wt.nrow()];
            this.Wx = new double[Wt.nrow()];
            this.Wtx = new double[Wt.ncol()];
            this.WtWx = new double[Wt.nrow()];
        }

        public int nrow() {
            return this.Wt.nrow();
        }

        public int ncol() {
            return this.nrow();
        }

        public long size() {
            return this.Wt.size();
        }

        public void mv(double[] work, int inputOffset, int outputOffset) {
            System.arraycopy(work, inputOffset, this.x, 0, this.x.length);
            this.Wt.tv(this.x, this.Wx);
            this.Wt.mv(this.x, this.Wtx);
            this.Wt.mv(this.Wx, this.WtWx);
            int n = this.x.length;
            for (int i = 0; i < n; ++i) {
                work[outputOffset + i] = this.WtWx[i] + this.x[i] - this.Wx[i] - this.Wtx[i];
            }
        }

        public void tv(double[] work, int inputOffset, int outputOffset) {
            throw new UnsupportedOperationException();
        }

        public void mv(Transpose trans, double alpha, double[] x, double beta, double[] y) {
            throw new UnsupportedOperationException();
        }
    }
}

