/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import smile.data.DataFrame;
import smile.data.transform.InvertibleColumnTransform;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.math.Function;
import smile.math.MathEx;

public class Standardizer {
    public static InvertibleColumnTransform fit(DataFrame data, String ... columns) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty data frame");
        }
        StructType schema = data.schema();
        if (columns.length == 0) {
            columns = (String[])Arrays.stream(schema.fields()).filter(StructField::isNumeric).map(field -> field.name).toArray(String[]::new);
        }
        HashMap<String, 1> transforms = new HashMap<String, 1>();
        HashMap<String, Function & Serializable> inverses = new HashMap<String, Function & Serializable>();
        for (String column : columns) {
            final StructField field2 = schema.field(column);
            if (!field2.isNumeric()) {
                throw new IllegalArgumentException(String.format("%s is not numeric", field2.name));
            }
            double[] vector = data.column(column).toDoubleArray();
            final double mu = MathEx.mean((double[])vector);
            double sd = MathEx.sd((double[])vector);
            final double scale = MathEx.isZero((double)sd) ? 1.0 : sd;
            Function transform = new Function(){

                public double f(double x) {
                    return (x - mu) / scale;
                }

                public String toString() {
                    return mu >= 0.0 ? String.format("(%s - %.4f) / %.4f", field2.name, mu, scale) : String.format("(%s + %.4f) / %.4f", field2.name, -mu, scale);
                }
            };
            Function & Serializable inverse = (Function & Serializable)x -> x * scale + mu;
            transforms.put(field2.name, transform);
            inverses.put(field2.name, inverse);
        }
        return new InvertibleColumnTransform("Standardizer", transforms, inverses);
    }
}

