/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import smile.data.DataFrame;
import smile.data.transform.InvertibleColumnTransform;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.math.Function;
import smile.math.MathEx;
import smile.sort.IQAgent;

public class RobustStandardizer {
    public static InvertibleColumnTransform fit(DataFrame data, String ... columns) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty data frame");
        }
        StructType schema = data.schema();
        if (columns.length == 0) {
            columns = (String[])Arrays.stream(schema.fields()).filter(StructField::isNumeric).map(field -> field.name).toArray(String[]::new);
        }
        HashMap<String, 1> transforms = new HashMap<String, 1>();
        HashMap<String, Function & Serializable> inverses = new HashMap<String, Function & Serializable>();
        for (String column : columns) {
            double[] vector;
            final StructField field2 = schema.field(column);
            if (!field2.isNumeric()) {
                throw new IllegalArgumentException(String.format("%s is not numeric", field2.name));
            }
            IQAgent agent = new IQAgent();
            for (double xi : vector = data.column(column).toDoubleArray()) {
                agent.add(xi);
            }
            final double median = agent.quantile(0.5);
            double iqr = agent.quantile(0.75) - agent.quantile(0.25);
            final double scale = MathEx.isZero((double)iqr) ? 1.0 : iqr;
            Function transform = new Function(){

                public double f(double x) {
                    return (x - median) / scale;
                }

                public String toString() {
                    return median >= 0.0 ? String.format("(%s - %.4f) / %.4f", field2.name, median, scale) : String.format("(%s + %.4f) / %.4f", field2.name, -median, scale);
                }
            };
            Function & Serializable inverse = (Function & Serializable)x -> x * scale + median;
            transforms.put(field2.name, transform);
            inverses.put(field2.name, inverse);
        }
        return new InvertibleColumnTransform("RobustStandardizer", transforms, inverses);
    }
}

