/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.imputation;

import smile.feature.imputation.SimpleImputer;
import smile.math.matrix.Matrix;

public interface SVDImputer {
    public static double[][] impute(double[][] data, int k, int maxIter) {
        if (k < 1 || k > Math.min(data.length, data[0].length)) {
            throw new IllegalArgumentException("Invalid number of eigenvectors for imputation: " + k);
        }
        if (maxIter < 1) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        int d = data[0].length;
        double[][] full = SimpleImputer.impute(data);
        for (int iter = 0; iter < maxIter; ++iter) {
            Matrix.SVD svd = Matrix.of((double[][])full).svd(true, true);
            for (int i = 0; i < data.length; ++i) {
                int missing = 0;
                for (int j = 0; j < d; ++j) {
                    if (Double.isNaN(data[i][j])) {
                        ++missing;
                        continue;
                    }
                    full[i][j] = data[i][j];
                }
                if (missing == 0) continue;
                Matrix A = new Matrix(d - missing, k);
                double[] b = new double[d - missing];
                int m = 0;
                for (int j = 0; j < d; ++j) {
                    if (Double.isNaN(data[i][j])) continue;
                    for (int l = 0; l < k; ++l) {
                        A.set(m, l, svd.V.get(j, l));
                    }
                    b[m++] = data[i][j];
                }
                Matrix.QR qr = A.qr(true);
                double[] s = qr.solve(b);
                for (int j = 0; j < d; ++j) {
                    if (!Double.isNaN(data[i][j])) continue;
                    full[i][j] = 0.0;
                    for (int l = 0; l < k; ++l) {
                        double[] dArray = full[i];
                        int n = j;
                        dArray[n] = dArray[n] + s[l] * svd.V.get(j, l);
                    }
                }
            }
        }
        return full;
    }
}

