/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.imputation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import smile.data.AbstractTuple;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.measure.NominalScale;
import smile.data.transform.Transform;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.feature.imputation.SimpleImputer;
import smile.math.MathEx;
import smile.math.distance.Distance;
import smile.neighbor.KNNSearch;
import smile.neighbor.LinearSearch;
import smile.neighbor.Neighbor;

public class KNNImputer
implements Transform {
    private final int k;
    private final KNNSearch<Tuple, Tuple> knn;

    public KNNImputer(DataFrame data, int k, Distance<Tuple> distance) {
        this.k = k;
        this.knn = LinearSearch.of((List)data.toList(), distance);
    }

    public KNNImputer(DataFrame data, int k, String ... columns) {
        this(data, k, (Distance<Tuple>)(Distance & Serializable)(x, y) -> {
            double[] xd = x.toArray(columns);
            double[] yd = y.toArray(columns);
            return MathEx.squaredDistanceWithMissingValues((double[])xd, (double[])yd);
        });
    }

    public Tuple apply(final Tuple x) {
        final StructType schema = x.schema();
        final Neighbor[] neighbors = this.knn.search((Object)x, this.k);
        return new AbstractTuple(){

            public Object get(int i) {
                Object xi = x.get(i);
                if (!SimpleImputer.isMissing(xi)) {
                    return xi;
                }
                StructField field = schema.field(i);
                if (field.type.isBoolean()) {
                    int[] vector = MathEx.omit((int[])Arrays.stream(neighbors).mapToInt(neighbor -> ((Tuple)neighbor.key).getInt(i)).toArray(), (int)Integer.MIN_VALUE);
                    return vector.length == 0 ? null : Boolean.valueOf(MathEx.mode((int[])vector) != 0);
                }
                if (field.type.isChar()) {
                    int[] vector = MathEx.omit((int[])Arrays.stream(neighbors).mapToInt(neighbor -> ((Tuple)neighbor.key).getInt(i)).toArray(), (int)Integer.MIN_VALUE);
                    return vector.length == 0 ? null : Character.valueOf((char)MathEx.mode((int[])vector));
                }
                if (field.measure instanceof NominalScale) {
                    int[] vector = MathEx.omit((int[])Arrays.stream(neighbors).mapToInt(neighbor -> ((Tuple)neighbor.key).getInt(i)).toArray(), (int)Integer.MIN_VALUE);
                    return vector.length == 0 ? null : Integer.valueOf(MathEx.mode((int[])vector));
                }
                if (field.type.isNumeric()) {
                    double[] vector = MathEx.omit((double[])Arrays.stream(neighbors).mapToDouble(neighbor -> ((Tuple)neighbor.key).getDouble(i)).toArray(), (double)-2.147483648E9);
                    return vector.length == 0 ? null : Double.valueOf(MathEx.mean((double[])vector));
                }
                return null;
            }

            public StructType schema() {
                return schema;
            }
        };
    }
}

