/*
 * Decompiled with CFR 0.152.
 */
package smile.base.mlp;

import smile.base.mlp.Cost;
import smile.math.MathEx;

public enum OutputFunction {
    LINEAR{

        @Override
        public void f(double[] x) {
        }

        @Override
        public void g(Cost cost, double[] g, double[] y) {
            switch (cost) {
                case MEAN_SQUARED_ERROR: {
                    break;
                }
                case LIKELIHOOD: {
                    throw new IllegalStateException("SOFTMAX must work with LIKELIHOOD cost function");
                }
            }
        }
    }
    ,
    SIGMOID{

        @Override
        public void f(double[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = MathEx.sigmoid((double)x[i]);
            }
        }

        @Override
        public void g(Cost cost, double[] g, double[] y) {
            switch (cost) {
                case MEAN_SQUARED_ERROR: {
                    for (int i = 0; i < g.length; ++i) {
                        int n = i;
                        g[n] = g[n] * (y[i] * (1.0 - y[i]));
                    }
                    break;
                }
            }
        }
    }
    ,
    SOFTMAX{

        @Override
        public void f(double[] x) {
            MathEx.softmax((double[])x);
        }

        @Override
        public void g(Cost cost, double[] g, double[] y) {
            switch (cost) {
                case MEAN_SQUARED_ERROR: {
                    throw new IllegalStateException("SOFTMAX must work with LIKELIHOOD cost function");
                }
            }
        }
    };


    public abstract void f(double[] var1);

    public abstract void g(Cost var1, double[] var2, double[] var3);
}

