/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

import smile.math.MathEx;
import smile.validation.metric.ClusteringMetric;
import smile.validation.metric.ContingencyTable;

public class RandIndex
implements ClusteringMetric {
    private static final long serialVersionUID = 2L;
    public static final RandIndex instance = new RandIndex();

    @Override
    public double score(int[] y1, int[] y2) {
        return RandIndex.of(y1, y2);
    }

    public static double of(int[] y1, int[] y2) {
        ContingencyTable contingency = new ContingencyTable(y1, y2);
        int n = contingency.n;
        int n1 = contingency.n1;
        int n2 = contingency.n2;
        int[] a = contingency.a;
        int[] b = contingency.b;
        int[][] count = contingency.table;
        double randT = 0.0;
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                randT += MathEx.sqr((double)count[i][j]);
            }
        }
        randT -= (double)n;
        double randP = 0.0;
        for (int i = 0; i < n1; ++i) {
            randP += MathEx.sqr((double)a[i]);
        }
        randP -= (double)n;
        double randQ = 0.0;
        for (int j = 0; j < n2; ++j) {
            randQ += MathEx.sqr((double)b[j]);
        }
        double rand = (randT - 0.5 * randP - 0.5 * (randQ -= (double)n) + MathEx.choose((int)n, (int)2)) / MathEx.choose((int)n, (int)2);
        return rand;
    }

    public String toString() {
        return "RandIndex";
    }
}

