/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

import smile.validation.metric.ClassificationMetric;
import smile.validation.metric.Precision;
import smile.validation.metric.Recall;

public class FScore
implements ClassificationMetric {
    private static final long serialVersionUID = 2L;
    public static final FScore F1 = new FScore(1.0);
    public static final FScore F2 = new FScore(2.0);
    public static final FScore FHalf = new FScore(0.5);
    private double beta = 1.0;

    @Override
    public double score(int[] truth, int[] prediction) {
        return FScore.of(this.beta, truth, prediction);
    }

    public FScore() {
        this(1.0);
    }

    public FScore(double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("Negative beta");
        }
        this.beta = beta;
    }

    public static double of(double beta, int[] truth, int[] prediction) {
        double beta2 = beta * beta;
        double p = Precision.of(truth, prediction);
        double r = Recall.of(truth, prediction);
        return (1.0 + beta2) * (p * r) / (beta2 * p + r);
    }

    public String toString() {
        return String.format("F-Score(%f)", this.beta);
    }
}

