/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.util.Arrays;
import java.util.function.BiFunction;
import smile.classification.Classifier;
import smile.classification.DataFrameClassifier;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.math.MathEx;
import smile.regression.DataFrameRegression;
import smile.regression.Regression;
import smile.util.IntSet;
import smile.validation.Bag;
import smile.validation.ClassificationValidation;
import smile.validation.ClassificationValidations;
import smile.validation.RegressionValidation;
import smile.validation.RegressionValidations;

public interface Bootstrap {
    public static Bag[] of(int n, int k) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid sample size: " + n);
        }
        if (k < 0) {
            throw new IllegalArgumentException("Invalid number of bootstrap: " + k);
        }
        Bag[] bags = new Bag[k];
        for (int j = 0; j < k; ++j) {
            boolean[] hit = new boolean[n];
            int hits = 0;
            int[] train = new int[n];
            for (int i = 0; i < n; ++i) {
                int r;
                train[i] = r = MathEx.randomInt((int)n);
                if (hit[r]) continue;
                ++hits;
                hit[r] = true;
            }
            int[] test = new int[n - hits];
            int p = 0;
            for (int i = 0; i < n; ++i) {
                if (hit[i]) continue;
                test[p++] = i;
            }
            bags[j] = new Bag(train, test);
        }
        return bags;
    }

    public static Bag[] of(int[] category, int k) {
        if (k < 0) {
            throw new IllegalArgumentException("Invalid number of bootstrap: " + k);
        }
        int[] unique = MathEx.unique((int[])category);
        int m = unique.length;
        Arrays.sort(unique);
        IntSet encoder = new IntSet(unique);
        int n = category.length;
        int[] y = category;
        if (unique[0] != 0 || unique[m - 1] != m - 1) {
            y = new int[n];
            for (int i = 0; i < n; ++i) {
                y[i] = encoder.indexOf(category[i]);
            }
        }
        int[] ni = new int[m];
        int[] nArray = y;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int i2;
            int n3 = i2 = nArray[i];
            ni[n3] = ni[n3] + 1;
        }
        int[][] strata = new int[m][];
        for (int i = 0; i < m; ++i) {
            strata[i] = new int[ni[i]];
        }
        int[] pos = new int[m];
        int i = 0;
        while (i < n) {
            int j;
            int n4 = j = y[i];
            int n5 = pos[n4];
            pos[n4] = n5 + 1;
            strata[j][n5] = i++;
        }
        Bag[] bags = new Bag[k];
        for (int round = 0; round < k; ++round) {
            boolean[] hit = new boolean[n];
            int hits = 0;
            int l = 0;
            int[] train = new int[n];
            for (int i3 = 0; i3 < m; ++i3) {
                int[] stratum = strata[i3];
                int size = ni[i3];
                for (int j = 0; j < size; ++j) {
                    int sample = stratum[MathEx.randomInt((int)size)];
                    train[l++] = sample;
                    if (hit[sample]) continue;
                    ++hits;
                    hit[sample] = true;
                }
            }
            int[] test = new int[n - hits];
            int p = 0;
            for (int i4 = 0; i4 < n; ++i4) {
                if (hit[i4]) continue;
                test[p++] = i4;
            }
            bags[round] = new Bag(train, test);
        }
        return bags;
    }

    public static <T, M extends Classifier<T>> ClassificationValidations<M> classification(int k, T[] x, int[] y, BiFunction<T[], int[], M> trainer) {
        return ClassificationValidation.of(Bootstrap.of(x.length, k), x, y, trainer);
    }

    public static <M extends DataFrameClassifier> ClassificationValidations<M> classification(int k, Formula formula, DataFrame data, BiFunction<Formula, DataFrame, M> trainer) {
        return ClassificationValidation.of(Bootstrap.of(data.size(), k), formula, data, trainer);
    }

    public static <T, M extends Regression<T>> RegressionValidations<M> regression(int k, T[] x, double[] y, BiFunction<T[], double[], M> trainer) {
        return RegressionValidation.of(Bootstrap.of(x.length, k), x, y, trainer);
    }

    public static <M extends DataFrameRegression> RegressionValidations<M> regression(int k, Formula formula, DataFrame data, BiFunction<Formula, DataFrame, M> trainer) {
        return RegressionValidation.of(Bootstrap.of(data.size(), k), formula, data, trainer);
    }
}

