/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.io.Serializable;
import java.util.function.ToDoubleFunction;
import smile.math.MathEx;

public interface Regression<T>
extends ToDoubleFunction<T>,
Serializable {
    public double predict(T var1);

    default public double[] predict(T[] x) {
        int n = x.length;
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            y[i] = this.predict(x[i]);
        }
        return y;
    }

    @Override
    default public double applyAsDouble(T x) {
        return this.predict(x);
    }

    default public Metric metric(T[] x, double[] y) {
        int n = x.length;
        double[] fittedValues = new double[n];
        for (int i = 0; i < n; ++i) {
            fittedValues[i] = this.predict(x[i]);
        }
        return new Metric(y, fittedValues);
    }

    default public Metric metric(double[] y, double[] fittedValues) {
        return new Metric(y, fittedValues);
    }

    public static class Metric {
        public final double[] y;
        public final double[] fittedValues;
        public final double[] residuals;
        public final double RSS;
        public final double RSquared;
        public final double MSE;
        public final double RMSE;
        public final double MAD;

        private Metric(double[] y, double[] fittedValues) {
            this.y = y;
            this.fittedValues = fittedValues;
            int n = y.length;
            this.residuals = new double[n];
            double mad = 0.0;
            double rss = 0.0;
            double TSS = 0.0;
            double ybar = MathEx.mean((double[])y);
            for (int i = 0; i < n; ++i) {
                double r;
                this.residuals[i] = r = y[i] - fittedValues[i];
                rss += r * r;
                mad += Math.abs(r);
                double t = y[i] - ybar;
                TSS += t * t;
            }
            this.RSS = rss;
            this.RSquared = 1.0 - this.RSS / TSS;
            this.MSE = Math.sqrt(rss / (double)n);
            this.RMSE = Math.sqrt(this.MSE);
            this.MAD = mad / (double)n;
        }
    }
}

