/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.stream.LongStream;
import smile.base.cart.CART;
import smile.base.cart.Loss;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.formula.Formula;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.feature.TreeSHAP;
import smile.math.MathEx;
import smile.regression.DataFrameRegression;
import smile.regression.Regression;
import smile.regression.RegressionTree;
import smile.validation.RegressionMetrics;
import smile.validation.metric.MAD;
import smile.validation.metric.MSE;
import smile.validation.metric.R2;
import smile.validation.metric.RMSE;
import smile.validation.metric.RSS;

public class RandomForest
implements Regression<Tuple>,
DataFrameRegression,
TreeSHAP {
    private static final long serialVersionUID = 2L;
    private Formula formula;
    private Model[] models;
    private RegressionMetrics metrics;
    private double[] importance;

    public RandomForest(Formula formula, Model[] models, RegressionMetrics metrics, double[] importance) {
        this.formula = formula;
        this.models = models;
        this.metrics = metrics;
        this.importance = importance;
    }

    public static RandomForest fit(Formula formula, DataFrame data) {
        return RandomForest.fit(formula, data, new Properties());
    }

    public static RandomForest fit(Formula formula, DataFrame data, Properties prop) {
        int ntrees = Integer.valueOf(prop.getProperty("smile.random.forest.trees", "500"));
        int mtry = Integer.valueOf(prop.getProperty("smile.random.forest.mtry", "0"));
        int maxDepth = Integer.valueOf(prop.getProperty("smile.random.forest.max.depth", "20"));
        int maxNodes = Integer.valueOf(prop.getProperty("smile.random.forest.max.nodes", String.valueOf(data.size() / 5)));
        int nodeSize = Integer.valueOf(prop.getProperty("smile.random.forest.node.size", "5"));
        double subsample = Double.valueOf(prop.getProperty("smile.random.forest.sample.rate", "1.0"));
        return RandomForest.fit(formula, data, ntrees, mtry, maxDepth, maxNodes, nodeSize, subsample);
    }

    public static RandomForest fit(Formula formula, DataFrame data, int ntrees, int mtry, int maxDepth, int maxNodes, int nodeSize, double subsample) {
        return RandomForest.fit(formula, data, ntrees, mtry, maxDepth, maxNodes, nodeSize, subsample, null);
    }

    public static RandomForest fit(Formula formula, DataFrame data, int ntrees, int mtry, int maxDepth, int maxNodes, int nodeSize, double subsample, LongStream seeds) {
        if (ntrees < 1) {
            throw new IllegalArgumentException("Invalid number of trees: " + ntrees);
        }
        if (subsample <= 0.0 || subsample > 1.0) {
            throw new IllegalArgumentException("Invalid sampling rate: " + subsample);
        }
        formula = formula.expand(data.schema());
        DataFrame x = formula.x(data);
        BaseVector response = formula.y(data);
        StructField field = response.field();
        double[] y = response.toDoubleArray();
        if (mtry > x.ncols()) {
            throw new IllegalArgumentException("Invalid number of variables to split on at a node of the tree: " + mtry);
        }
        int mtryFinal = mtry > 0 ? mtry : Math.max(x.ncols() / 3, 1);
        int n = x.nrows();
        double[] prediction = new double[n];
        int[] oob = new int[n];
        int[][] order = CART.order(x);
        long[] seedArray = (seeds != null ? seeds : LongStream.range(-ntrees, 0L)).sequential().distinct().limit(ntrees).toArray();
        if (seedArray.length != ntrees) {
            throw new IllegalArgumentException(String.format("seed stream has only %d distinct values, expected %d", seedArray.length, ntrees));
        }
        Model[] models = (Model[])Arrays.stream(seedArray).parallel().mapToObj(seed -> {
            if (seed > 1L) {
                MathEx.setSeed((long)seed);
            }
            int[] samples = new int[n];
            if (subsample == 1.0) {
                for (int i = 0; i < n; ++i) {
                    int n2 = MathEx.randomInt((int)n);
                    samples[n2] = samples[n2] + 1;
                }
            } else {
                int[] permutation = MathEx.permutate((int)n);
                int N = (int)Math.round((double)n * subsample);
                for (int i = 0; i < N; ++i) {
                    samples[permutation[i]] = 1;
                }
            }
            long start = System.nanoTime();
            RegressionTree tree = new RegressionTree(x, Loss.ls(y), field, maxDepth, maxNodes, nodeSize, mtryFinal, samples, order);
            double fitTime = (double)(System.nanoTime() - start) / 1000000.0;
            start = System.nanoTime();
            int noob = 0;
            for (int i = 0; i < n; ++i) {
                if (samples[i] != 0) continue;
                ++noob;
            }
            double[] truth = new double[noob];
            double[] predict = new double[noob];
            int j = 0;
            for (int i = 0; i < n; ++i) {
                double yi;
                if (samples[i] != 0) continue;
                truth[j] = y[i];
                predict[j] = yi = tree.predict((Tuple)x.get(i));
                int n3 = i;
                oob[n3] = oob[n3] + 1;
                int n4 = i;
                prediction[n4] = prediction[n4] + yi;
                ++j;
            }
            double scoreTime = (double)(System.nanoTime() - start) / 1000000.0;
            RegressionMetrics metrics = new RegressionMetrics(fitTime, scoreTime, noob, RSS.of(truth, predict), MSE.of(truth, predict), RMSE.of(truth, predict), MAD.of(truth, predict), R2.of(truth, predict));
            return new Model(tree, metrics);
        }).toArray(Model[]::new);
        double fitTime = 0.0;
        double scoreTime = 0.0;
        for (Model model : models) {
            fitTime += model.metrics.fitTime;
            scoreTime += model.metrics.scoreTime;
        }
        for (int i = 0; i < n; ++i) {
            if (oob[i] <= 0) continue;
            int n2 = i;
            prediction[n2] = prediction[n2] / (double)oob[i];
        }
        RegressionMetrics metrics = new RegressionMetrics(fitTime, scoreTime, n, RSS.of(y, prediction), MSE.of(y, prediction), RMSE.of(y, prediction), MAD.of(y, prediction), R2.of(y, prediction));
        double[] importance = RandomForest.calculateImportance(models);
        return new RandomForest(formula, models, metrics, importance);
    }

    private static double[] calculateImportance(Model[] models) {
        double[] importance = new double[models[0].tree.importance().length];
        for (Model model : models) {
            double[] imp = model.tree.importance();
            for (int i = 0; i < imp.length; ++i) {
                int n = i;
                importance[n] = importance[n] + imp[i];
            }
        }
        return importance;
    }

    @Override
    public Formula formula() {
        return this.formula;
    }

    @Override
    public StructType schema() {
        return this.models[0].tree.schema();
    }

    public RegressionMetrics metrics() {
        return this.metrics;
    }

    public double[] importance() {
        return this.importance;
    }

    public int size() {
        return this.models.length;
    }

    public Model[] models() {
        return this.models;
    }

    public RegressionTree[] trees() {
        return (RegressionTree[])Arrays.stream(this.models).map(model -> model.tree).toArray(RegressionTree[]::new);
    }

    public RandomForest trim(int ntrees) {
        if (ntrees > this.models.length) {
            throw new IllegalArgumentException("The new model size is larger than the current size.");
        }
        if (ntrees <= 0) {
            throw new IllegalArgumentException("Invalid new model size: " + ntrees);
        }
        Arrays.sort(this.models, Comparator.comparingDouble(model -> model.metrics.rmse));
        return new RandomForest(this.formula, Arrays.copyOf(this.models, ntrees), this.metrics, this.importance);
    }

    public RandomForest merge(RandomForest other) {
        if (!this.formula.equals((Object)other.formula)) {
            throw new IllegalArgumentException("RandomForest have different model formula");
        }
        Model[] forest = new Model[this.models.length + other.models.length];
        System.arraycopy(this.models, 0, forest, 0, this.models.length);
        System.arraycopy(other.models, 0, forest, this.models.length, other.models.length);
        RegressionMetrics mergedMetrics = new RegressionMetrics(this.metrics.fitTime * other.metrics.fitTime, this.metrics.scoreTime * other.metrics.scoreTime, this.metrics.size, this.metrics.rss * other.metrics.rss / 2.0, this.metrics.mse * other.metrics.mse / 2.0, this.metrics.rmse * other.metrics.rmse / 2.0, this.metrics.mad * other.metrics.mad / 2.0, this.metrics.r2 * other.metrics.r2 / 2.0);
        double[] mergedImportance = (double[])this.importance.clone();
        for (int i = 0; i < this.importance.length; ++i) {
            int n = i;
            mergedImportance[n] = mergedImportance[n] + other.importance[i];
        }
        return new RandomForest(this.formula, forest, mergedMetrics, mergedImportance);
    }

    @Override
    public double predict(Tuple x) {
        Tuple xt = this.formula.x(x);
        double y = 0.0;
        for (Model model : this.models) {
            y += model.tree.predict(xt);
        }
        return y / (double)this.models.length;
    }

    public double[][] test(DataFrame data) {
        DataFrame x = this.formula.x(data);
        int n = x.nrows();
        int ntrees = this.models.length;
        double[][] prediction = new double[ntrees][n];
        for (int j = 0; j < n; ++j) {
            Tuple xj = (Tuple)x.get(j);
            double base = 0.0;
            for (int i = 0; i < ntrees; ++i) {
                prediction[i][j] = (base += this.models[i].tree.predict(xj)) / (double)(i + 1);
            }
        }
        return prediction;
    }

    public static class Model
    implements Serializable {
        public final RegressionTree tree;
        public final RegressionMetrics metrics;

        Model(RegressionTree tree, RegressionMetrics metrics) {
            this.tree = tree;
            this.metrics = metrics;
        }
    }
}

