/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import java.io.Serializable;
import smile.math.MathEx;
import smile.math.blas.UPLO;
import smile.math.matrix.Matrix;
import smile.projection.LinearProjection;

public class PCA
implements LinearProjection,
Serializable {
    private static final long serialVersionUID = 2L;
    private int p;
    private int n;
    private double[] mu;
    private double[] pmu;
    private Matrix eigvectors;
    private double[] eigvalues;
    private double[] proportion;
    private double[] cumulativeProportion;
    private Matrix projection;

    public PCA(double[] mu, double[] eigvalues, Matrix loadings) {
        this.mu = mu;
        this.eigvalues = eigvalues;
        this.eigvectors = loadings;
        this.n = mu.length;
        this.proportion = (double[])eigvalues.clone();
        MathEx.unitize1((double[])this.proportion);
        this.cumulativeProportion = new double[eigvalues.length];
        this.cumulativeProportion[0] = this.proportion[0];
        for (int i = 1; i < eigvalues.length; ++i) {
            this.cumulativeProportion[i] = this.cumulativeProportion[i - 1] + this.proportion[i];
        }
        this.setProjection(0.95);
    }

    public static PCA fit(double[][] data) {
        Matrix eigvectors;
        double[] eigvalues;
        int m = data.length;
        int n = data[0].length;
        double[] mu = MathEx.colMeans((double[][])data);
        Matrix X = new Matrix(data);
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                X.sub(i, j, mu[j]);
            }
        }
        if (m > n) {
            Matrix.SVD svd = X.svd(true, true);
            eigvalues = svd.s;
            for (int i = 0; i < eigvalues.length; ++i) {
                int n2 = i;
                eigvalues[n2] = eigvalues[n2] * eigvalues[i];
            }
            eigvectors = svd.V;
        } else {
            Matrix cov = new Matrix(n, n);
            for (int k = 0; k < m; ++k) {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        cov.add(i, j, X.get(k, i) * X.get(k, j));
                    }
                }
            }
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j <= i; ++j) {
                    cov.div(i, j, (double)m);
                    cov.set(j, i, cov.get(i, j));
                }
            }
            cov.uplo(UPLO.LOWER);
            Matrix.EVD eigen = cov.eigen(false, true, true).sort();
            eigvalues = eigen.wr;
            eigvectors = eigen.Vr;
        }
        return new PCA(mu, eigvalues, eigvectors);
    }

    public static PCA cor(double[][] data) {
        int j;
        int i;
        int i2;
        int m = data.length;
        int n = data[0].length;
        double[] mu = MathEx.colMeans((double[][])data);
        Matrix x = new Matrix(data);
        for (int j2 = 0; j2 < n; ++j2) {
            for (i2 = 0; i2 < m; ++i2) {
                x.sub(i2, j2, mu[j2]);
            }
        }
        Matrix cov = new Matrix(n, n);
        for (int k = 0; k < m; ++k) {
            for (i = 0; i < n; ++i) {
                for (j = 0; j <= i; ++j) {
                    cov.add(i, j, x.get(k, i) * x.get(k, j));
                }
            }
        }
        for (i2 = 0; i2 < n; ++i2) {
            for (int j3 = 0; j3 <= i2; ++j3) {
                cov.div(i2, j3, (double)m);
                cov.set(j3, i2, cov.get(i2, j3));
            }
        }
        double[] sd = new double[n];
        for (i = 0; i < n; ++i) {
            sd[i] = Math.sqrt(cov.get(i, i));
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j <= i; ++j) {
                cov.div(i, j, sd[i] * sd[j]);
                cov.set(j, i, cov.get(i, j));
            }
        }
        cov.uplo(UPLO.LOWER);
        Matrix.EVD eigen = cov.eigen(false, true, true).sort();
        Matrix loadings = eigen.Vr;
        for (int i3 = 0; i3 < n; ++i3) {
            for (int j4 = 0; j4 < n; ++j4) {
                loadings.div(i3, j4, sd[i3]);
            }
        }
        return new PCA(mu, eigen.wr, loadings);
    }

    public double[] getCenter() {
        return this.mu;
    }

    public Matrix getLoadings() {
        return this.eigvectors;
    }

    public double[] getVariance() {
        return this.eigvalues;
    }

    public double[] getVarianceProportion() {
        return this.proportion;
    }

    public double[] getCumulativeVarianceProportion() {
        return this.cumulativeProportion;
    }

    @Override
    public Matrix getProjection() {
        return this.projection;
    }

    public PCA setProjection(int p) {
        if (p < 1 || p > this.n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        this.p = p;
        this.projection = new Matrix(p, this.n);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < p; ++j) {
                this.projection.set(j, i, this.eigvectors.get(i, j));
            }
        }
        this.pmu = this.projection.mv(this.mu);
        return this;
    }

    public PCA setProjection(double p) {
        if (p <= 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid percentage of variance: " + p);
        }
        for (int k = 0; k < this.n; ++k) {
            if (!(this.cumulativeProportion[k] >= p)) continue;
            this.setProjection(k + 1);
            break;
        }
        return this;
    }

    @Override
    public double[] project(double[] x) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.n));
        }
        double[] y = this.projection.mv(x);
        MathEx.sub((double[])y, (double[])this.pmu);
        return y;
    }

    @Override
    public double[][] project(double[][] x) {
        if (x[0].length != this.mu.length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x[0].length, this.n));
        }
        double[][] y = new double[x.length][this.p];
        for (int i = 0; i < x.length; ++i) {
            this.projection.mv(x[i], y[i]);
            MathEx.sub((double[])y[i], (double[])this.pmu);
        }
        return y;
    }
}

