/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import smile.math.distance.Metric;
import smile.neighbor.Neighbor;
import smile.neighbor.RNNSearch;

public class BKTree<E>
implements RNNSearch<E, E>,
Serializable {
    private static final long serialVersionUID = 2L;
    private Node root;
    private Metric<E> distance;
    private int count = 0;

    public BKTree(Metric<E> distance) {
        this.distance = distance;
    }

    public void add(E[] data) {
        for (E datum : data) {
            this.add(datum);
        }
    }

    public void add(Collection<E> data) {
        for (E datum : data) {
            this.add(datum);
        }
    }

    public String toString() {
        return String.format("BK-Tree (%s)", this.distance);
    }

    public void add(E datum) {
        if (this.root == null) {
            this.root = new Node(this.count++, datum);
        } else {
            this.root.add(datum);
        }
    }

    private void search(Node node, E q, int k, List<Neighbor<E, E>> neighbors) {
        int d = (int)this.distance.d(node.object, q);
        if (d <= k && node.object != q) {
            neighbors.add(new Neighbor(node.object, node.object, node.index, d));
        }
        if (node.children != null) {
            int start = Math.max(1, d - k);
            int end = Math.min(node.children.size(), d + k + 1);
            for (int i = start; i < end; ++i) {
                Node child = node.children.get(i);
                if (child == null) continue;
                this.search(child, q, k, neighbors);
            }
        }
    }

    @Override
    public void range(E q, double radius, List<Neighbor<E, E>> neighbors) {
        if (radius <= 0.0 || radius != (double)((int)radius)) {
            throw new IllegalArgumentException("The parameter radius has to be an integer: " + radius);
        }
        this.search(this.root, q, (int)radius, neighbors);
    }

    public void range(E q, int radius, List<Neighbor<E, E>> neighbors) {
        this.search(this.root, q, radius, neighbors);
    }

    class Node
    implements Serializable {
        E object;
        int index;
        ArrayList<Node> children;

        Node(int index, E object) {
            this.index = index;
            this.object = object;
        }

        private void add(E datum) {
            int d = (int)BKTree.this.distance.d(this.object, datum);
            if (d == 0) {
                return;
            }
            if (this.children == null) {
                this.children = new ArrayList();
            }
            while (this.children.size() <= d) {
                this.children.add(null);
            }
            Node child = this.children.get(d);
            if (child == null) {
                Node node = new Node(BKTree.this.count++, datum);
                this.children.set(d, node);
            } else {
                child.add(datum);
            }
        }
    }
}

