/*
 * Decompiled with CFR 0.152.
 */
package smile.imputation;

import smile.clustering.KMeans;
import smile.clustering.PartitionClustering;
import smile.imputation.MissingValueImputation;
import smile.imputation.MissingValueImputationException;

public class KMeansImputation
implements MissingValueImputation {
    private int k;
    private int runs;

    public KMeansImputation(int k) {
        this(k, 8);
    }

    public KMeansImputation(int k, int runs) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid number of clusters: " + k);
        }
        if (runs < 1) {
            throw new IllegalArgumentException("Invalid runs: " + runs);
        }
        this.k = k;
        this.runs = runs;
    }

    @Override
    public void impute(double[][] data) throws MissingValueImputationException {
        int i;
        int[] count = new int[data[0].length];
        for (i = 0; i < data.length; ++i) {
            int n = 0;
            for (int j = 0; j < data[i].length; ++j) {
                if (!Double.isNaN(data[i][j])) continue;
                ++n;
                int n2 = j;
                count[n2] = count[n2] + 1;
            }
            if (n != data[i].length) continue;
            throw new MissingValueImputationException("The whole row " + i + " is missing");
        }
        for (i = 0; i < data[0].length; ++i) {
            if (count[i] != data.length) continue;
            throw new MissingValueImputationException("The whole column " + i + " is missing");
        }
        KMeans kmeans = PartitionClustering.run(this.runs, () -> KMeans.lloyd(data, this.k));
        for (int i2 = 0; i2 < this.k; ++i2) {
            if (kmeans.size[i2] <= 0) continue;
            double[][] d = new double[kmeans.size[i2]][];
            int m = 0;
            for (int j = 0; j < data.length; ++j) {
                if (kmeans.y[j] != i2) continue;
                d[m++] = data[j];
            }
            MissingValueImputation.imputeWithColumnAverage(d);
        }
        MissingValueImputation.imputeWithColumnAverage(data);
    }
}

