/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import smile.data.DataFrame;
import smile.data.type.StructType;
import smile.feature.Scaler;
import smile.sort.IQAgent;

public class WinsorScaler
extends Scaler {
    private static final long serialVersionUID = 2L;

    public WinsorScaler(StructType schema, double[] lo, double[] hi) {
        super(schema, lo, hi);
    }

    public static WinsorScaler fit(DataFrame data) {
        return WinsorScaler.fit(data, 0.05, 0.95);
    }

    public static WinsorScaler fit(DataFrame data, double lower, double upper) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty data frame");
        }
        if (lower < 0.0 || lower > 0.5) {
            throw new IllegalArgumentException("Invalid lower limit: " + lower);
        }
        if (upper < 0.5 || upper > 1.0) {
            throw new IllegalArgumentException("Invalid upper limit: " + upper);
        }
        if (upper <= lower) {
            throw new IllegalArgumentException("Invalid lower and upper limit pair: " + lower + " >= " + upper);
        }
        StructType schema = data.schema();
        double[] lo = new double[schema.length()];
        double[] hi = new double[schema.length()];
        for (int i = 0; i < lo.length; ++i) {
            if (!schema.field(i).isNumeric()) continue;
            int col = i;
            IQAgent agent = new IQAgent();
            ((Stream)data.stream().sequential()).forEach(t -> agent.add(t.getDouble(col)));
            lo[i] = agent.quantile(lower);
            hi[i] = agent.quantile(upper);
        }
        return new WinsorScaler(schema, lo, hi);
    }

    public static WinsorScaler fit(double[][] data) {
        return WinsorScaler.fit(DataFrame.of((double[][])data, (String[])new String[0]));
    }

    public static WinsorScaler fit(double[][] data, double lower, double upper) {
        return WinsorScaler.fit(DataFrame.of((double[][])data, (String[])new String[0]), lower, upper);
    }

    @Override
    public String toString() {
        return IntStream.range(0, this.lo.length).mapToObj(i -> String.format("%s[%.4f, %.4f]", this.schema.field((int)i).name, this.lo[i], this.hi[i])).collect(Collectors.joining(",", "WinsorScaler(", ")"));
    }
}

