/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import java.util.stream.Stream;
import smile.base.cart.CART;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.formula.Formula;
import smile.feature.SHAP;

public interface TreeSHAP
extends SHAP<Tuple> {
    public CART[] trees();

    public Formula formula();

    @Override
    default public double[] shap(Tuple x) {
        CART[] forest = this.trees();
        Tuple xt = this.formula().x(x);
        double[] phi = null;
        for (CART tree : forest) {
            double[] phii = tree.shap(xt);
            if (phi == null) {
                phi = phii;
                continue;
            }
            for (int i = 0; i < phi.length; ++i) {
                int n = i;
                phi[n] = phi[n] + phii[i];
            }
        }
        int i = 0;
        while (i < phi.length) {
            int n = i++;
            phi[n] = phi[n] / (double)forest.length;
        }
        return phi;
    }

    @Override
    default public double[] shap(DataFrame data) {
        this.formula().bind(data.schema());
        return this.shap((Stream)data.stream().parallel());
    }
}

