/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import smile.data.AbstractTuple;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.data.vector.DoubleVector;
import smile.feature.FeatureTransform;
import smile.math.MathEx;

public class Scaler
implements FeatureTransform {
    private static final long serialVersionUID = 2L;
    StructType schema;
    double[] lo;
    double[] hi;

    public Scaler(StructType schema, double[] lo, double[] hi) {
        if (schema.length() != lo.length || lo.length != hi.length) {
            throw new IllegalArgumentException("Schema and scaling factor size don't match");
        }
        this.schema = schema;
        this.lo = lo;
        this.hi = hi;
        for (int i = 0; i < lo.length; ++i) {
            int n = i;
            hi[n] = hi[n] - lo[i];
            if (!MathEx.isZero((double)hi[i])) continue;
            hi[i] = 1.0;
        }
    }

    public static Scaler fit(DataFrame data) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty data frame");
        }
        StructType schema = data.schema();
        double[] lo = new double[schema.length()];
        double[] hi = new double[schema.length()];
        for (int i = 0; i < lo.length; ++i) {
            if (!schema.field(i).isNumeric()) continue;
            lo[i] = ((DoubleStream)data.doubleVector(i).stream()).min().getAsDouble();
            hi[i] = ((DoubleStream)data.doubleVector(i).stream()).max().getAsDouble();
        }
        return new Scaler(schema, lo, hi);
    }

    public static Scaler fit(double[][] data) {
        return Scaler.fit(DataFrame.of((double[][])data, (String[])new String[0]));
    }

    private double scale(double x, int i) {
        double y = (x - this.lo[i]) / this.hi[i];
        if (y < 0.0) {
            y = 0.0;
        }
        if (y > 1.0) {
            y = 1.0;
        }
        return y;
    }

    @Override
    public double[] transform(double[] x) {
        double[] y = new double[x.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = this.scale(x[i], i);
        }
        return y;
    }

    @Override
    public Tuple transform(final Tuple x) {
        if (!this.schema.equals((Object)x.schema())) {
            throw new IllegalArgumentException(String.format("Invalid schema %s, expected %s", x.schema(), this.schema));
        }
        return new AbstractTuple(){

            public Object get(int i) {
                if (Scaler.this.schema.field(i).isNumeric()) {
                    return Scaler.this.scale(x.getDouble(i), i);
                }
                return x.get(i);
            }

            public StructType schema() {
                return Scaler.this.schema;
            }
        };
    }

    @Override
    public DataFrame transform(DataFrame data) {
        if (!this.schema.equals((Object)data.schema())) {
            throw new IllegalArgumentException(String.format("Invalid schema %s, expected %s", data.schema(), this.schema));
        }
        BaseVector[] vectors = new BaseVector[this.schema.length()];
        for (int i = 0; i < this.lo.length; ++i) {
            StructField field = this.schema.field(i);
            if (field.isNumeric()) {
                int col = i;
                DoubleStream stream = data.stream().mapToDouble(t -> this.scale(t.getDouble(col), col));
                vectors[i] = DoubleVector.of((StructField)field, (DoubleStream)stream);
                continue;
            }
            vectors[i] = data.column(i);
        }
        return DataFrame.of((BaseVector[])vectors);
    }

    public String toString() {
        return IntStream.range(0, this.lo.length).mapToObj(i -> String.format("%s[%.4f, %.4f]", this.schema.field((int)i).name, this.lo[i], this.hi[i])).collect(Collectors.joining(",", "Scaler(", ")"));
    }
}

