/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

import smile.math.MathEx;
import smile.math.distance.Distance;

public abstract class Linkage {
    int size;
    float[] proximity;

    public Linkage(double[][] proximity) {
        this.size = proximity.length;
        this.proximity = new float[this.size * (this.size + 1) / 2];
        int k = 0;
        for (int j = 0; j < this.size; ++j) {
            int i = j;
            while (i < this.size) {
                this.proximity[k] = (float)proximity[i][j];
                ++i;
                ++k;
            }
        }
    }

    public Linkage(int size, float[] proximity) {
        if (proximity.length != size * (size + 1) / 2) {
            throw new IllegalArgumentException(String.format("The length of proximity is %d, expected %d", proximity.length, size * (size + 1) / 2));
        }
        this.size = size;
        this.proximity = proximity;
    }

    int index(int i, int j) {
        return i > j ? this.proximity.length - (this.size - j) * (this.size - j + 1) / 2 + i - j : this.proximity.length - (this.size - i) * (this.size - i + 1) / 2 + j - i;
    }

    public int size() {
        return this.size;
    }

    public float d(int i, int j) {
        return this.proximity[this.index(i, j)];
    }

    public abstract void merge(int var1, int var2);

    public static float[] proximity(double[][] data) {
        int n = data.length;
        int length = n * (n + 1) / 2;
        float[] proximity = new float[length];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                int k = length - (n - j) * (n - j + 1) / 2 + i - j;
                proximity[k] = (float)MathEx.distance((double[])data[i], (double[])data[j]);
            }
        }
        return proximity;
    }

    public static <T> float[] proximity(T[] data, Distance<T> distance) {
        int n = data.length;
        int length = n * (n + 1) / 2;
        float[] proximity = new float[length];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                int k = length - (n - j) * (n - j + 1) / 2 + i - j;
                proximity[k] = (float)distance.d(data[i], data[j]);
            }
        }
        return proximity;
    }
}

